#include "mbed.h"
#include "Mycan.h"
#include "USS.h"
#include "hardwareConfig.h"

int main() 
{
    timer.start();
    uss[0].startTriger();
    uss[1].startTriger();
    while(1) 
    {
        LED_RED = LED_BLUE = 0;
        if(sw[8] == 1)
            LED_RED = 1;
        else LED_BLUE = 1;
        
        int swich[13];
        for(int i = 0; i < 13; i++)
            swich[i] = sw[i];
        
        for(int i = 0; i < 6; i++)
            can.set(6, i + 1, swich[i]);
        
        //送信周期調整
        static double pre_time0 = 0;
        double now_time0 = timer.read();
        if(now_time0 - pre_time0 >= 0.1)
        {
            if(can.send())
            {
                pre_time0 = now_time0;
                LED[0] = !LED[0];
            }
        }
        
        for(int i = 1; i < 5; i++)
            can.set(7, i, swich[i + 5]);
        can.set(7, 6, swich[11]);
        if(swich[8] == 0)
        {
            can.set(7, 5, swich[12]);
            can.set(7, 7, swich[10]);
        }
        else
        {
            can.set(7, 5, swich[10]);
            can.set(7, 7, swich[12]);
        }
        
        //送信周期調整
        static double pre_time1 = 0;
        double now_time1 = timer.read();
        if(now_time1 - pre_time1 >= 0.1)
        {
            if(can.send())
            {
                pre_time1 = now_time1;
                LED[1] = !LED[1];
            }
        }
    
        if(sw[8] == 1)
            can.set(8, 1, int(uss[0].distance / 2));
        else can.set(8, 1, int(uss[1].distance / 2));
        can.set(8, 2, int(uss[2].distance / 2));
        
        //送信周期調整
        static double pre_time2 = 0;
        double now_time2 = timer.read();
        if(now_time2 - pre_time2 >= 0.02)
        {
            if(can.send())
            {
                pre_time2 = now_time2;
                LED[2] = !LED[2];
            }
        }
        
        for(int i = 9; i < 13; i++)
            pc.printf("%d\t", swich[i]);
        
        pc.printf("%.1f\t", uss[0].distance);
        pc.printf("%.1f\t", uss[1].distance);
        pc.printf("%.1f\t", uss[2].distance);
        //pc.printf("%.1f\t", uss[3].distance);
        
        pc.printf("\n");
    }
}