//オンボードLEDの使用宣言
DigitalOut LED[] = {DigitalOut(LED1),
                    DigitalOut(LED2),
                    DigitalOut(LED3),
                    DigitalOut(LED4),
                   };

//デバック用シリアル
Serial pc(USBTX, USBRX);

//CAN用 (rd, td)
Mycan can(p30, p29);

//メカナム逆運動学モデルのヤコビアン
float jacobian[4][3] = {{ 1, -1, -1},
                        { 1,  1, -1},
                        {-1,  1, -1},
                        {-1, -1, -1}
                       };
                       
//(逆運動学モデル, ホイールの計算100%定義)
DriveController mecanum(jacobian, 0.8);

//sbus用 (tx, rx)
SBUS sbus(p28, p27);

//(計算周期時間[s], sla, sld)
IMU imu(0.01, p9, p10);

//(pwmPin, direPin)
MDD Motor[4] = {  MDD(p24, p26),
                  MDD(p23, p25),
                  MDD(p22, p20),
                  MDD(p21, p19)
               };
               
Timer timer;

//(A相, B相)
RotaryEncoder enc[2] = {RotaryEncoder(p14 , p13 , &timer, 100),
                        RotaryEncoder(p16, p15, &timer, 100)
                       };
                       
DigitalIn sw1(p5);
DigitalIn sw2(p6);

//(trig, echo)     
USS uss[3] = {USS(p11, p12), USS(p7, p8), USS(p17, p18)};

             
//コントローラー入力のための構造体
typedef struct controller {
    float LX, LY, RX, RY;
    int A,B,C,D,E,F,G,H;
    int fail_safe;
} controller;