#include "mbed.h"
#include "DRV8835.h"
#include "Adafruit_ST7735.h"
#include "QEI.h"
#include "LSM303D.h"

DRV8835 motors(p23,p18,p24,p11); //attach motors
LSM303D comp(p5,p6,p7,p15); //attach compass for magnetometer
Adafruit_ST7735 tft(p5,p6,p7,p12,p8); //attach LCD screen
QEI Left(p30,p29,NC,909.72,QEI::X4_ENCODING);  //encoder object for left wheel
QEI Right(p17,p16,NC,909.72,QEI::X4_ENCODING);  //encoder object for right wheel
AnalogIn batt(p19); //battery pin


int main() {
    
    //declare battery voltage
    float volts;
    
    //initialize compass
    comp.initialize();   
        
    //continuously drive and update sensor values on screen
    while(1) {
        
        //read battery voltage
        volts=batt.read()*9.9;
        
        //clear screen and reset cursor
        tft.fillScreen(0x0000);
        tft.setCursor(0,0); 
        
        //print voltage, magnetometer values, and encoder values
        tft.printf("Voltage: %2.2f\r\n\r\n",volts);
        tft.printf("X Magnet: %d\r\n\r\n",comp.magnetometer(XAXIS));    
        tft.printf("Y Magnet: %d\r\n\r\n",comp.magnetometer(YAXIS));  
        tft.printf("Z Magnet: %d\r\n\r\n",comp.magnetometer(ZAXIS));  
        tft.printf("R Encoder: %d\r\n\r\n",Right.getPulses());
        tft.printf("L Encoder: %d",Left.getPulses());
        
        //perform drive test
        
        //drive forward
        motors.motorR_fwd(0.2);
        motors.motorL_fwd(0.2);
        wait(1.0);
        motors.motorR_stop();
        motors.motorL_stop();
        wait(1.0);
        
        //drive backward
        motors.motorR_rev(0.2);
        motors.motorL_rev(0.2);
        wait(1.0);
        motors.motorR_stop();
        motors.motorL_stop();
        wait(1.0);
        
        //turn
        motors.motorR_fwd(0.2);
        motors.motorL_rev(0.2);
        wait(1.0);
        motors.motorR_stop();
        motors.motorL_stop();
        wait(1.0);
    }
}
