using namespace std;

#include "mbed.h"
#include "spi_master.h"
#include "adxl345.h"
#include "ble/BLE.h"
#include "ble/Gap.h"
#include "ble/UUID.h"
#include "ble/GattCharacteristic.h"
#include "ble/GattCallbackParamTypes.h"
#include "ble/GattServer.h"

//#define CS      P0_7                                //chipselect
#define MOSI    P0_9                                //Master Out Slave In
#define MISO    P0_11                               //Master In Slave Out
#define SCK     P0_8                                //Clock
//additional IO
#define ON_SW   P0_28                               //ON/OFF switch
#define BEPB    P0_29                               //Enable/disable bluetooth push button
#define CHARACT_DATA 0

#define MIN_CONN_INTERVAL 10 //250 milliseconds
#define MAX_CONN_INTERVAL 30 //350 milliseconds

DigitalOut spi_cs(P0_28);
DigitalIn int1(P0_15);
DigitalIn location(P0_07);
SPIClass SPI1(NRF_SPI1);
data_member_t data[513];
BLEDevice ble;
Gap::Handle_t connectionHandle = 0xFFFF;

/*SET UUID*/
const UUID GATT_SERVICE = "88888888-5555-4444-1111-777777777777";
const UUID ADV_DATA = "11001100-2200-3300-4400-550055005500";
const UUID RECV_DATA = "22002200-3300-4400-5500-660066006600";
char *compbuf= new char[26];
uint16_t compbufLen=0;
char *sendbuf= new char[26];
char *sendbufaddr=sendbuf;
uint16_t sendbufLen=20*sizeof(uint8_t);
char *readystr = "data ready";
uint16_t readyLen = sizeof("data ready");
char *startstr = "START";
uint16_t startLen = sizeof("START");
char *sendstr = "SEND";
uint16_t sendLen = sizeof("SEND");
bool data_ready;
uint16_t sendindex;
uint8_t *AdvData= new uint8_t[26];
uint16_t AdvDataLen=0;
uint8_t *RcvData= new uint8_t[26];
uint16_t RcvDataLen=0;
uint8_t devnr = 1;
unsigned count;
/* Device Name, simpel discovey */
const static char DEVICE_NAME[] = "Trump";
GattCharacteristic gattchar = GattCharacteristic(ADV_DATA, AdvData, AdvDataLen, 26, GattCharacteristic::BLE_GATT_CHAR_PROPERTIES_NOTIFY|GattCharacteristic::BLE_GATT_CHAR_PROPERTIES_READ);
GattCharacteristic rxCharacteristic = GattCharacteristic(RECV_DATA, RcvData, RcvDataLen, 26, GattCharacteristic::BLE_GATT_CHAR_PROPERTIES_WRITE_WITHOUT_RESPONSE);// | GattCharacteristic::BLE_GATT_CHAR_PROPERTIES_READ);

GattCharacteristic *CHARACT_ARRAY[] = {&gattchar,&rxCharacteristic};
GattService gatt_service(GATT_SERVICE,CHARACT_ARRAY,2);
GattAttribute::Handle_t writeHandle;
GattAttribute::Handle_t readHandle;


    

bool poll_start_send_data(uint8_t *compare_str, uint8_t comp_length){
    uint16_t bufLen = 27;
    uint8_t *rdbuf= new uint8_t[bufLen];
    ble.readCharacteristicValue(readHandle,rdbuf,&bufLen);
    for (uint8_t i=0 ; i<comp_length-1 ; i++)
    {
        if (*(rdbuf+i*sizeof(uint8_t)) != *(compare_str+i*sizeof(uint8_t)))
        {
            delete rdbuf;
            return false;
        }
    }
    delete rdbuf;
    return true;
}

void Flash_Buff_WriteBytes(uint8_t addr, uint8_t pbuf)
{    
    spi_cs = 0;
    wait_us(200);      
    SPI1.transfer((uint8_t)addr);     
    SPI1.transfer(pbuf);       
    
    wait_us(200);
    spi_cs = 1;
}

void Flash_Buff_ReadBytes(uint8_t addr, uint8_t *pbuf)
{    
    spi_cs = 0;
    wait_us(20);
          
    SPI1.transfer((uint8_t)addr|0x80);     
    *pbuf = SPI1.transfer(0x00);
    
    wait_us(20);
    spi_cs = 1;
}

void init_adxl()
{
    Flash_Buff_WriteBytes(INT_ENABLE, 0x00);
    Flash_Buff_WriteBytes(THRESH_TAP, THRESH_TAP_INIT);
    Flash_Buff_WriteBytes(OFSX, OFSX_INIT);
    Flash_Buff_WriteBytes(OFSY, OFSY_INIT);
    Flash_Buff_WriteBytes(OFSZ, OFSZ_INIT);
    Flash_Buff_WriteBytes(DUR, DUR_INIT);
    Flash_Buff_WriteBytes(Latent, Latent_INIT);
    Flash_Buff_WriteBytes(Window, Window_INIT);
    Flash_Buff_WriteBytes(THRESH_ACT, THRESH_ACT_INIT);
    Flash_Buff_WriteBytes(THRESH_INACT, THRESH_INACT_INIT);
    Flash_Buff_WriteBytes(TIME_INACT, TIME_INACT_INIT);
    Flash_Buff_WriteBytes(ACT_INACT_CTL, ACT_INACT_CTL_INIT);
    Flash_Buff_WriteBytes(THRESH_FF, THRESH_FF_INIT);
    Flash_Buff_WriteBytes(TIME_FF, TIME_FF_INIT);
    Flash_Buff_WriteBytes(TAP_AXES, TAP_AXES_INIT);
    Flash_Buff_WriteBytes(BW_RATE, BW_RATE_INIT);
    Flash_Buff_WriteBytes(POWER_CTL, POWER_CTL_INIT);
    Flash_Buff_WriteBytes(INT_MAP, INT_MAP_INIT);
    Flash_Buff_WriteBytes(DATA_FORMAT, DATA_FORMAT_INIT);
    Flash_Buff_WriteBytes(FIFO_CTL, FIFO_CTL_INIT);
    Flash_Buff_WriteBytes(POWER_CTL, POWER_CTL_INIT | 0x08);
    Flash_Buff_WriteBytes(INT_ENABLE, INT_ENABLE_INIT);
}

void read_data(uint16_t index)
{
    spi_cs = 0;
    wait_us(20);
    
    SPI1.transfer((uint8_t)(DATAX0|0xC0));
    data[index].data_x0 = SPI1.transfer(0x00)^0x80;
    data[index].data_x1 = SPI1.transfer(0x00);
    data[index].data_y0 = SPI1.transfer(0x00)^0x80;
    data[index].data_y1 = SPI1.transfer(0x00);
    data[index].data_z0 = SPI1.transfer(0x00)^0x80;
    data[index].data_z1 = SPI1.transfer(0x00);
    
    wait_us(20);
    spi_cs = 1;
}


/* WHEN CONNECTION ...  */
void connectionCallback(const Gap::ConnectionCallbackParams_t *params) {
    if (params->role == Gap::CENTRAL) {
        connectionHandle = params->handle;
    }
}


/* Restart advertising when the peer disconnects */
void disconnectionCallback(const Gap::DisconnectionCallbackParams_t *params)
{
    BLE::Instance().gap().startAdvertising();
}

/*This function is called when the ble initialization process has failed*/
void onBleInitError(BLE &ble, ble_error_t error)
{
    /* Avoid compiler warnings, library said to do this */
    (void) ble;
    (void) error;
    
    /* Initialization error handling should go here */
}

void dataSentCallback(unsigned count)
{
    SPI1.transfer(0xCC);
    sendindex+=1;
    memcpy(sendbufaddr+0*sizeof(uint8_t), &sendindex, sizeof(uint16_t));
    memcpy(sendbufaddr+2*sizeof(uint8_t), &(data[sendindex].data_x0), sizeof(uint8_t));
    memcpy(sendbufaddr+3*sizeof(uint8_t), &(data[sendindex].data_x1), sizeof(uint8_t));
    memcpy(sendbufaddr+4*sizeof(uint8_t), &(data[sendindex].data_y0), sizeof(uint8_t));
    memcpy(sendbufaddr+5*sizeof(uint8_t), &(data[sendindex].data_y1), sizeof(uint8_t));
    memcpy(sendbufaddr+6*sizeof(uint8_t), &(data[sendindex].data_z0), sizeof(uint8_t));
    memcpy(sendbufaddr+7*sizeof(uint8_t), &(data[sendindex].data_z1), sizeof(uint8_t));
    sendindex+=1;
    memcpy(sendbufaddr+8*sizeof(uint8_t), &(data[sendindex].data_x0), sizeof(uint8_t));
    memcpy(sendbufaddr+9*sizeof(uint8_t), &(data[sendindex].data_x1), sizeof(uint8_t));
    memcpy(sendbufaddr+10*sizeof(uint8_t), &(data[sendindex].data_y0), sizeof(uint8_t));
    memcpy(sendbufaddr+11*sizeof(uint8_t), &(data[sendindex].data_y1), sizeof(uint8_t));
    memcpy(sendbufaddr+12*sizeof(uint8_t), &(data[sendindex].data_z0), sizeof(uint8_t));
    memcpy(sendbufaddr+13*sizeof(uint8_t), &(data[sendindex].data_z1), sizeof(uint8_t));
    sendindex+=1;
    memcpy(sendbufaddr+14*sizeof(uint8_t), &(data[sendindex].data_x0), sizeof(uint8_t));
    memcpy(sendbufaddr+15*sizeof(uint8_t), &(data[sendindex].data_x1), sizeof(uint8_t));
    memcpy(sendbufaddr+16*sizeof(uint8_t), &(data[sendindex].data_y0), sizeof(uint8_t));
    memcpy(sendbufaddr+17*sizeof(uint8_t), &(data[sendindex].data_y1), sizeof(uint8_t));
    memcpy(sendbufaddr+18*sizeof(uint8_t), &(data[sendindex].data_z0), sizeof(uint8_t));
    memcpy(sendbufaddr+19*sizeof(uint8_t), &(data[sendindex].data_z1), sizeof(uint8_t));
    if(sendindex>=512)
        data_ready=false;
    
}

/*Callback triggered when ble initialization process has finished*/
void bleInitComplete(BLE::InitializationCompleteCallbackContext *params)
{
    BLE&        ble   = params->ble;
    ble_error_t error = params->error;

/* In case of error, forward the error handling to onBleInitError */
    if (error != BLE_ERROR_NONE) {
        onBleInitError(ble, error);
        return;
    }

    /* Ensure that it is the default instance of BLE */
    if(ble.getInstanceID() != BLE::DEFAULT_INSTANCE) {
        return;
    }
    
    /* Set device name characteristic data */
    ble.gap().setDeviceName((const uint8_t *) DEVICE_NAME);
    
    ble.gattServer().onDataSent(dataSentCallback);
        
    
    /* callback when disconnected */
    ble.gap().onDisconnection(disconnectionCallback);

    /* Sacrifice 3B of 31B to some Advertising Flags (see nrfconnect toolbox for flag parameters :) ) */
    // for
    ble.gap().accumulateAdvertisingPayload(GapAdvertisingData::BREDR_NOT_SUPPORTED | GapAdvertisingData::LE_GENERAL_DISCOVERABLE);// say this device can be discovered by other BLE supportingdevices
    ble.gap().setAdvertisingType(GapAdvertisingParams::ADV_CONNECTABLE_UNDIRECTED); // say that a connection can be set ( connectable) and that it does not matter with who it connects (unidirected)

    
    /* Sacrifice another 2B of 31B (actually 29B) to AdvType overhead, rest goes to AdvData array --> about 26B of actual sendable data :o */
    //Overhead  = 1B Length, 1B Type
    //Type = AdvData
    //Length = sizeof(AdvData)
    //ble.gap().accumulateAdvertisingPayload(GapAdvertisingData::SERVICE_DATA, AdvData, sizeof(AdvData));

    /*fill in device name as local name*/
    ble.gap().accumulateAdvertisingPayload(GapAdvertisingData::COMPLETE_LOCAL_NAME, (uint8_t *)DEVICE_NAME, sizeof(DEVICE_NAME));

    /* Set advertising interval. Longer interval == Less radiothingies use == longer battery life :) */
    ble.gap().setAdvertisingInterval(20); /* 100ms */
    


    ble.addService(gatt_service);

    //ble.gap().addData(GapAdvertisingData::SERVICE_DATA, (uint8_t *)AdvData, sizeof(AdvData));
    /* Start advertising */
    ble.gap().startAdvertising(); //start sending advertising packets
    
    ble.initializeSecurity();
    //end
}


main() {
    wait_ms(1);
    data_ready=false;
    BLE& ble = BLE::Instance();
    ble.init(bleInitComplete);
    spi_cs = 1;
    if (location==1) {
        char *waitingstr = "waiting1";
        uint16_t waitingLen = sizeof("waiting1"); }
    else if(location==0) {
        char *waitingstr = "waiting0";
        uint16_t waitingLen = sizeof("waiting0"); }
    uint16_t index;
    for(uint16_t i=0; i<513;i++){
        data[i].data_x0=(uint8_t)0;
        data[i].data_x1=(uint8_t)0;
        data[i].data_y0=(uint8_t)0;
        data[i].data_y1=(uint8_t)0;
        data[i].data_z0=(uint8_t)0;
        data[i].data_z1=(uint8_t)0;
    }
    SPI1.begin(SCK, MOSI, MISO);
    init_adxl();
    writeHandle = gattchar.getValueHandle();
    readHandle = rxCharacteristic.getValueHandle();
    
    while(1)
    {
        ble.gattServer().write(writeHandle,(uint8_t *)waitingstr, waitingLen);
        while (poll_start_send_data((uint8_t *)startstr, startLen) != true)
        {   
            ble.waitForEvent();
        }
        //SPI
        Flash_Buff_WriteBytes(POWER_CTL, POWER_CTL_INIT | 0x08);
        for (index=0 ; index<513 ; index++){
            while(!int1){wait_us(1);}
            read_data(index);
        }
        Flash_Buff_WriteBytes(POWER_CTL, POWER_CTL_INIT | 0x04);
        ble.gattServer().write(writeHandle,(uint8_t *)readystr, readyLen);
        //condition to send data
        while (poll_start_send_data((uint8_t *)sendstr, sendLen) != true)
        {   
            ble.waitForEvent();
        }
        index=0;
        sendindex=2;
        data_ready=true;
        memcpy(sendbufaddr+0*sizeof(uint8_t), &index, sizeof(uint16_t));
        memcpy(sendbufaddr+2*sizeof(uint8_t), &(data[index].data_x0), sizeof(uint8_t));
        memcpy(sendbufaddr+3*sizeof(uint8_t), &(data[index].data_x1), sizeof(uint8_t));
        memcpy(sendbufaddr+4*sizeof(uint8_t), &(data[index].data_y0), sizeof(uint8_t));
        memcpy(sendbufaddr+5*sizeof(uint8_t), &(data[index].data_y1), sizeof(uint8_t));
        memcpy(sendbufaddr+6*sizeof(uint8_t), &(data[index].data_z0), sizeof(uint8_t));
        memcpy(sendbufaddr+7*sizeof(uint8_t), &(data[index].data_z1), sizeof(uint8_t));
        memcpy(sendbufaddr+8*sizeof(uint8_t), &(data[index+1].data_x0), sizeof(uint8_t));
        memcpy(sendbufaddr+9*sizeof(uint8_t), &(data[index+1].data_x1), sizeof(uint8_t));
        memcpy(sendbufaddr+10*sizeof(uint8_t), &(data[index+1].data_y0), sizeof(uint8_t));
        memcpy(sendbufaddr+11*sizeof(uint8_t), &(data[index+1].data_y1), sizeof(uint8_t));
        memcpy(sendbufaddr+12*sizeof(uint8_t), &(data[index+1].data_z0), sizeof(uint8_t));
        memcpy(sendbufaddr+13*sizeof(uint8_t), &(data[index+1].data_z1), sizeof(uint8_t));
        memcpy(sendbufaddr+14*sizeof(uint8_t), &(data[index+2].data_x0), sizeof(uint8_t));
        memcpy(sendbufaddr+15*sizeof(uint8_t), &(data[index+2].data_x1), sizeof(uint8_t));
        memcpy(sendbufaddr+16*sizeof(uint8_t), &(data[index+2].data_y0), sizeof(uint8_t));
        memcpy(sendbufaddr+17*sizeof(uint8_t), &(data[index+2].data_y1), sizeof(uint8_t));
        memcpy(sendbufaddr+18*sizeof(uint8_t), &(data[index+2].data_z0), sizeof(uint8_t));
        memcpy(sendbufaddr+19*sizeof(uint8_t), &(data[index+2].data_z1), sizeof(uint8_t));
        wait(2);
        while (data_ready == true)
        {   
            ble.gattServer().write(writeHandle, (uint8_t *)sendbufaddr, sendbufLen);
            ble.waitForEvent();
            
        }
    }
}