#define DEVID 0x00
#define THRESH_TAP 0x1D
#define OFSX 0x1E
#define OFSY 0x1F
#define OFSZ 0x20
#define DUR 0x21
#define Latent 0x22
#define Window 0x23
#define THRESH_ACT 0x24
#define THRESH_INACT 0x25
#define TIME_INACT 0x26
#define ACT_INACT_CTL 0x27
#define THRESH_FF 0x28
#define TIME_FF 0x29
#define TAP_AXES 0x2A
#define ACT_TAP_STATUS 0x2B
#define BW_RATE 0x2C
#define POWER_CTL 0x2D
#define INT_ENABLE 0x2E
#define INT_MAP 0x2F
#define INT_SOURCE 0x30
#define DATA_FORMAT 0x31
#define DATAX0 0x32
#define DATAX1 0x33
#define DATAY0 0x34
#define DATAY1 0x35
#define DATAZ0 0x36
#define DATAZ1 0x37
#define FIFO_CTL 0x38
#define FIFO_STATUS 0x39

struct data_member_t {
    uint8_t data_x0;
    uint8_t data_x1;
    uint8_t data_y0;
    uint8_t data_y1;
    uint8_t data_z0;
    uint8_t data_z1;
};


#define THRESH_TAP_INIT 0x00
    // Not used->reset interrupt
#define OFSX_INIT 0x00
#define OFSY_INIT 0x00
#define OFSZ_INIT 0x00
    // No ofsets
#define DUR_INIT 0x00
    // Disable single/double tap function
#define Latent_INIT 0x00
    // Disable double tap function
#define Window_INIT 0x00
    // Disable double tap function
#define THRESH_ACT_INIT 0x0A
    // 62.5mg/LSB
#define THRESH_INACT_INIT 0x09
    // 62.5mg/LSB
#define TIME_INACT_INIT 0x08
    // 1s/LSB
    // Wait 8 seconds after inactivity
#define ACT_INACT_CTL_INIT 0xF8
    // D7 ACT AC/DC   1
    // D6 ACT_X_EN    1
    // D5 ACT_Y_EN    1
    // D4 ACT_Z_EN    1
    // D3 INACT AC/DC 1
    // D2 INACT_X_EN  0
    // D1 INACT_Y_EN  0
    // D0 INACT_Z_EN  0
#define THRESH_FF_INIT 0x00
    // Not used->reset interrupt
#define TIME_FF_INIT 0x00
    // Not used->reset interrupt
#define TAP_AXES_INIT 0x00
    // Disable taps
#define BW_RATE_INIT 0x0F
    // D7-D5         000
    // D4 LOW_POWER  0
    // D3-D0 RATE    1111       (1.6kHz)
#define POWER_CTL_INIT 0x00
    // D7-D6         00
    // D5 Link       0
    // D4 AUTO_SLEEP 0
    // D3 Measure    0
    // D2 Sleep      0
    // D1-D0 Wakeup  00         (8Hz)
#define INT_ENABLE_INIT 0x80
    // D7 DATA_READY 1
    // D6 SINGLE_TAP 0
    // D5 DOUBLE_TAP 0
    // D4 Activity   0
    // D3 Inactivity 0
    // D2 FREE_FALL  0
    // D1 Watermark  0
    // D0 Overrun    0
#define INT_MAP_INIT 0x00
    // All set to INT1 pin
    // D7 DATA_READY 0
    // D6 SINGLE_TAP 0
    // D5 DOUBLE_TAP 0
    // D4 Activity   0
    // D3 Inactivity 0
    // D2 FREE_FALL  0
    // D1 Watermark  0
    // D0 Overrun    0
#define DATA_FORMAT_INIT 0x0F
    // D7 SELF_TEST  0
    // D6 SPI        0            (4-wire)
    // D5 INT_INVERT 0            (Active high)
    // D4            0
    // D3 FULL_RES   1
    // D2 Justify    1            (Left justified MSB first)
    // D1-D0 Range   11           (16g)
#define FIFO_CTL_INIT 0x3F
    // D7-D6 FIFO_MODE 00         (Bypass)
    // D5 Trigger      1
    // D4-D0 SAMPLES   11111
    
