
#include "mbed.h"
#include "ble/BLE.h"
#include "ble/Gap.h"
#include "ble/UUID.h"
#include "ble/GattCharacteristic.h"

BLEDevice ble;

/* Device Name, simpel discovey */
const static char     DEVICE_NAME[] = "ThisIsBLE1";

/*SET UUID*/
const UUID GATT_SERVICE = "88888888-5555-4444-1111-777777777777";
const UUID ADV_DATA = "11001100-2200-3300-4400-550055005500";

#define CHARACT_DATA 0



/* You have up to 26 bytes of advertising data to use. */
// for
uint8_t AdvData[] = {0x43,0x10,'d','u','m','m','y',0x02,0x02,0,1,7,81};   /* Example of hex data */
uint8_t *datapointer = &AdvData[2];

GattCharacteristic gatt_characteristics(ADV_DATA,AdvData,(sizeof(AdvData)-2),26,GattCharacteristic::BLE_GATT_CHAR_PROPERTIES_READ);

GattCharacteristic *CHARACT_ARRAY[] = {&gatt_characteristics};

GattService gatt_service(GATT_SERVICE,CHARACT_ARRAY,1);
// end
const BLEProtocol::AddressBytes_t  peerAddr = {0xb8, 0x27, 0xeb, 0x25, 0x00, 0xc4};
BLEProtocol::AddressType_t         peerAddrType = (BLEProtocol::AddressType::RANDOM_STATIC);
//const ConnectionParams_t          *connectionParams;
//const GapScanningParams           *scanParams;


/* Restart advertising when the peer disconnects */
void disconnectionCallback(const Gap::DisconnectionCallbackParams_t *params)
{
    BLE::Instance().gap().startAdvertising();
}

/*This function is called when the ble initialization process has failed*/
void onBleInitError(BLE &ble, ble_error_t error)
{
    /* Avoid compiler warnings, library said to do this */
    (void) ble;
    (void) error;
    
    /* Initialization error handling should go here */
}    

/*Callback triggered when ble initialization process has finished*/
void bleInitComplete(BLE::InitializationCompleteCallbackContext *params)
{
    BLE&        ble   = params->ble;
    ble_error_t error = params->error;

/* In case of error, forward the error handling to onBleInitError */
    if (error != BLE_ERROR_NONE) {
        onBleInitError(ble, error);
        return;
    }

    /* Ensure that it is the default instance of BLE */
    if(ble.getInstanceID() != BLE::DEFAULT_INSTANCE) {
        return;
    }
    
    /* Set device name characteristic data */
    ble.gap().setDeviceName((const uint8_t *) DEVICE_NAME);
        
    
    /* callback when disconnected */
    ble.gap().onDisconnection(disconnectionCallback);

    /* Sacrifice 3B of 31B to some Advertising Flags (see nrfconnect toolbox for flag parameters :) ) */
    // for
    ble.gap().accumulateAdvertisingPayload(GapAdvertisingData::BREDR_NOT_SUPPORTED | GapAdvertisingData::LE_GENERAL_DISCOVERABLE);// say this device can be discovered by other BLE supportingdevices
    ble.gap().setAdvertisingType(GapAdvertisingParams::ADV_CONNECTABLE_UNDIRECTED); // say that a connection can be set ( connectable) and that it does not matter with who it connects (unidirected)

    
    /* Sacrifice another 2B of 31B (actually 29B) to AdvType overhead, rest goes to AdvData array --> about 26B of actual sendable data :o */
    //Overhead  = 1B Length, 1B Type
    //Type = AdvData
    //Length = sizeof(AdvData)
    ble.gap().accumulateAdvertisingPayload(GapAdvertisingData::SERVICE_DATA, AdvData, sizeof(AdvData));

    /*fill in device name as local name*/
    ble.gap().accumulateAdvertisingPayload(GapAdvertisingData::COMPLETE_LOCAL_NAME, (uint8_t *)DEVICE_NAME, sizeof(DEVICE_NAME));

    /* Set advertising interval. Longer interval == Less radiothingies use == longer battery life :) */
    ble.gap().setAdvertisingInterval(100); /* 100ms */
    


    ble.addService(gatt_service);

    //ble.gap().addData(GapAdvertisingData::SERVICE_DATA, (uint8_t *)AdvData, sizeof(AdvData));
    /* Start advertising */
    ble.gap().startAdvertising(); //start sending advertising packets
    
    ble.initializeSecurity();
    //end
}

int main(void)
{
    // VERSPILT ENERGIE wait(1);
    BLE& ble = BLE::Instance(BLE::DEFAULT_INSTANCE);
 
    /* Initialize BLE baselayer, library said : "always do this first!" so we will do  */
    ble.init(bleInitComplete);

    /* Infinite loop waiting for BLE events */
    while (true) {
        /* Save power while waiting for callback events */
        ble.waitForEvent(); //this is like a sleep function, waking up on interrupts like disconnection or so 
    }
}
