#define ADDR_ADS1015_0 0b10010010 //VDD
#define ADDR_ADS1015_1 0b10010000 //GND
#define ADDR_ADS1015_2 0b10010100 //SDA
#define ADDR_ADS1015_3 0b10010110 //SCL

#define AD1015_REG_CONVERSION_RESULT 0x00
#define AD1015_REG_CONFIG 0x01
#define ADS1015_REG_CONFIG_OS_SINGLE    (0x8000)

#define ADS1015_REG_CONFIG_MUX_SINGLE_0 (0x4000)  // Single-ended AIN0
#define ADS1015_REG_CONFIG_MUX_SINGLE_1 (0x5000)  // Single-ended AIN1
#define ADS1015_REG_CONFIG_MUX_SINGLE_2 (0x6000)  // Single-ended AIN2
#define ADS1015_REG_CONFIG_MUX_SINGLE_3 (0x7000)  // Single-ended AIN3

#define AD1015_CONFIG_FSR_6144 0x0000
#define AD1015_CONFIG_FSR_4096 0x0200
#define AD1015_CONFIG_FSR_2048 0x0400
#define AD1015_CONFIG_FSR_1024 0x0600
#define AD1015_CONFIG_FSR_0512 0x0800
#define AD1015_CONFIG_FSR_0256 0x0A00
#define AD1015_CONFIG_MUX_AIN0_AIN1 0x0000
#define AD1015_CONFIG_MUX_AIN0_AIN3 0x1000
#define AD1015_CONFIG_MUX_AIN1_AIN3 0x2000
#define AD1015_CONFIG_MUX_AIN2_AIN3 0x3000
#define AD1015_CONFIG_MUX_AIN0_GND 0x4000
#define AD1015_CONFIG_MUX_AIN1_GND 0x5000
#define AD1015_CONFIG_MUX_AIN2_GND 0x6000
#define AD1015_CONFIG_MUX_AIN3_GND 0x7000

double getDifSample(I2C* i2c_plate, uint8_t ADC_address, uint16_t sensor_address);
double getSingleSample(I2C* i2c_plate, uint8_t ADC_address, uint16_t channel);
void startSingleShotConversion(I2C* i2c_plate, uint8_t address, uint16_t config);
double readConversionResult(I2C* i2c_plate, uint8_t address, uint16_t config);
double data_to_voltage(int16_t data, uint16_t config);