#include "mbed.h"
#include "ADS1015.h"

#define ADS1015_CONFIG_DEFAULT 0x81E3

double getDifSample(I2C* i2c_plate, uint8_t ADC_address, uint16_t channel)
{
    uint16_t config = ADS1015_CONFIG_DEFAULT | channel | AD1015_CONFIG_FSR_4096;

    startSingleShotConversion(i2c_plate, ADC_address, config);
    wait_ms(0.4);
    startSingleShotConversion(i2c_plate, ADC_address, config);
    wait_ms(0.3);

    return readConversionResult(i2c_plate, ADC_address, config);
}

double getSingleSample(I2C* i2c_plate, uint8_t ADC_address, uint16_t channel)
{
    uint16_t config = ADS1015_CONFIG_DEFAULT | AD1015_CONFIG_FSR_6144;

    switch (channel) { // NOTE: CASES ADJUSTED -> CHANNEL 0 != ...MUX_SINGLE_0
        case (3): 
            config |= ADS1015_REG_CONFIG_MUX_SINGLE_0;
            break;
        case (0):
            config |= ADS1015_REG_CONFIG_MUX_SINGLE_1;
            break;
        case (1):
            config |= ADS1015_REG_CONFIG_MUX_SINGLE_2;
            break;
        case (2):
            config |= ADS1015_REG_CONFIG_MUX_SINGLE_3;
            break;
    }

    startSingleShotConversion(i2c_plate, ADC_address, config);
    //wait_ms(0.4);
    //startSingleShotConversion(i2c_plate, ADC_address, config);
    //wait_ms(0.3);

    return readConversionResult(i2c_plate, ADC_address, config);
}

void startSingleShotConversion(I2C* i2c_plate, uint8_t address, uint16_t config)
{
    char txbuf[10];
    // set mux to correct input
    txbuf[0] = AD1015_REG_CONFIG;
    txbuf[1] = config >> 8;
    txbuf[2] = config & 0xFF;
    i2c_plate->write(address, txbuf, 3);
}

double readConversionResult(I2C* i2c_plate, uint8_t address, uint16_t config)
{
    int16_t raw_data;
    char rxbuf[10];
    char txbuf[10];
    txbuf[0] = AD1015_REG_CONVERSION_RESULT;
    i2c_plate->write(address, txbuf, 1, true);
    i2c_plate->read(address, rxbuf, 2);
    raw_data = (rxbuf[0] << 8) | rxbuf[1];
    return data_to_voltage(raw_data, config);
}

double data_to_voltage(int16_t data, uint16_t config)
{
    double voltage;
    data = data >> 4;
    switch(config & 0x0E00) {
        case AD1015_CONFIG_FSR_6144:
            voltage = (double)data;
            break;
        case AD1015_CONFIG_FSR_4096:
            voltage = 0.002 * (double)data;
            break;
        case AD1015_CONFIG_FSR_2048:
            voltage = 0.001 * (double)data;
            break;
        case AD1015_CONFIG_FSR_1024:
            voltage = 0.0005 * (double)data;
            break;
        case AD1015_CONFIG_FSR_0512:
            voltage = 0.00025 * (double)data;
            break;
        case AD1015_CONFIG_FSR_0256:
            voltage = 0.000125 * (double)data;
            break;
        default:
            break;
    }
    return voltage;
}
