#include "mbed.h"

extern "C" {
#include "Controller_Master.h"         /* Model's header file */
#include "rtwtypes.h"
}

DigitalOut led_B(LED_BLUE);
DigitalOut led_R(LED_RED);
DigitalOut led_G(LED_GREEN);
Ticker t;
Serial  pc(USBTX, USBRX); // tx, rx

static RT_MODEL_Controller_Master_T Controller_Master_M_;
static RT_MODEL_Controller_Master_T *const Controller_Master_M =
    &Controller_Master_M_;               /* Real-time model */
static B_Controller_Master_T Controller_Master_B;/* Observable signals */
static DW_Controller_Master_T Controller_Master_DW;/* Observable states */

/* '<Root>/V' */
static real_T Controller_Master_U_V;

/* '<Root>/D_M' */
static real_T Controller_Master_U_D_M;

/* '<Root>/SLAVE' */
static uint8_T Controller_Master_U_Slave;

/* '<Root>/BRAKE' */
static uint8_T Controller_Master_Y_BRAKE;

/* '<Root>/LED_BLUE' */
static uint8_T Controller_Master_Y_LED_BLUE;

/* '<Root>/LED_RED' */
static uint8_T Controller_Master_Y_LED_RED;

/* '<Root>/MASTER' */
static uint8_T Controller_Master_Y_MASTER;

/*
 * Associating rt_OneStep with a real-time clock or interrupt service routine
 * is what makes the generated code "real-time".  The function rt_OneStep is
 * always associated with the base rate of the model.  Subrates are managed
 * by the base rate from inside the generated code.  Enabling/disabling
 * interrupts and floating point context switches are target specific.  This
 * example code indicates where these should take place relative to executing
 * the generated code step function.  Overrun behavior should be tailored to
 * your application needs.  This example simply sets an error status in the
 * real-time model and returns from rt_OneStep.
 */
void rt_OneStep(RT_MODEL_Controller_Master_T *const Controller_Master_M);
void rt_OneStep(RT_MODEL_Controller_Master_T *const Controller_Master_M)
{
    static boolean_T OverrunFlag = false;

    /* Disable interrupts here */

    /* Check for overrun */
    if (OverrunFlag) {
        rtmSetErrorStatus(Controller_Master_M, "Overrun");
        return;
    }

    OverrunFlag = true;

    /* Save FPU context here (if necessary) */
    /* Re-enable timer or interrupt here */
    /* Set model inputs here */

    /* Step the model */
    Controller_Master_step(Controller_Master_M, Controller_Master_U_V,
                           Controller_Master_U_D_M, Controller_Master_U_Slave,
                           &Controller_Master_Y_BRAKE, &Controller_Master_Y_LED_BLUE,
                           &Controller_Master_Y_LED_RED, &Controller_Master_Y_MASTER);

    /* Get model outputs here */

    /* Indicate task complete */
    OverrunFlag = false;

    /* Disable interrupts here */
    /* Restore FPU context here (if necessary) */
    /* Enable interrupts here */
}

void step();
void step()
{
    Controller_Master_U_V = 50;
    Controller_Master_U_D_M = 30;
    Controller_Master_U_Slave = 1;
    rt_OneStep(Controller_Master_M); 
    pc.printf("blue: %d \n", Controller_Master_Y_LED_BLUE);    // Call read_cm() to get the distance in cm
    pc.printf("red: %d \n", Controller_Master_Y_LED_RED);
    pc.printf("master: %d \n", Controller_Master_Y_MASTER);
    pc.printf("brake: %d \n", Controller_Master_Y_BRAKE);
    led_B = !Controller_Master_Y_LED_BLUE;         // negate because 1 -> led off
    led_R = !Controller_Master_Y_LED_RED;
    //led_G = !Controller_Master_Y_MASTER;
}

int main()
{
    /* Pack model data into RTM */
    Controller_Master_M->ModelData.blockIO = &Controller_Master_B;
    Controller_Master_M->ModelData.dwork = &Controller_Master_DW;
    
    
    Controller_Master_U_V = 50;
    Controller_Master_U_D_M = 50;
    Controller_Master_U_Slave = 1;
    
    /* Initialize model */
    Controller_Master_initialize(Controller_Master_M, &Controller_Master_U_V,
                                 &Controller_Master_U_D_M, &Controller_Master_U_Slave,
                                 &Controller_Master_Y_BRAKE, &Controller_Master_Y_LED_BLUE,
                                 &Controller_Master_Y_LED_RED, &Controller_Master_Y_MASTER);

    /* Attach rt_OneStep to a timer or interrupt service routine with
     * period 0.2 seconds (the model's base sample time) here.  The
     * call syntax for rt_OneStep is
     *
     *  rt_OneStep(Controller_Master_M);
     */
    t.attach(&step,0.2);
    led_B.write(1);
    led_G.write(1);
    led_R.write(1);
    while (true) {
        wait(0.2);
        //led_R= !led_R;

    }

    /* Disable rt_OneStep() here */

    /* Terminate model */
    Controller_Master_terminate(Controller_Master_M);
}