#include "mbed.h"
#include "Ultrasonic.h"

extern "C" {
#include "Controller_Master.h"         /* Model's header file */
#include "rtwtypes.h"
}

static RT_MODEL_Controller_Master_T Controller_Master_M_;
static RT_MODEL_Controller_Master_T *const Controller_Master_M =
    &Controller_Master_M_;               /* Real-time model */
static B_Controller_Master_T Controller_Master_B;/* Observable signals */
static DW_Controller_Master_T Controller_Master_DW;/* Observable states */
static real_T Controller_Master_U_V;
static real_T Controller_Master_U_D_M;
static uint8_T Controller_Master_U_Slave;
static boolean_T Controller_Master_U_QA_EN;
static uint8_T Controller_Master_Y_BRAKE;
static uint8_T Controller_Master_Y_ACC;
static uint8_T Controller_Master_Y_LED_RED;
static uint8_T Controller_Master_Y_LED_GREEN;
static uint8_T Controller_Master_Y_LED_BLUE;
static uint8_T Controller_Master_Y_MASTER;

void rt_OneStep(RT_MODEL_Controller_Master_T *const Controller_Master_M);
void step();
void cb();
void cb() {};

Ultrasonic sonic(D6,D7);  // Just call this funtion to initialize the ultrasonic sensor
// D2 trigger D4 echo
DigitalOut led_R(LED_RED);
DigitalOut led_G(LED_GREEN);
DigitalOut led_B(LED_BLUE);
DigitalOut master_out(D5);
DigitalOut acc(D2);
DigitalOut brake(D3);
DigitalIn  qa(D4);
float V = 29;   // Set the vehicle speed here
Ticker t;
Serial  pc(USBTX, USBRX); // tx, rx
Serial  myrio(D1,D0 ); // tx, rx

int main()
{
    /* Pack model data into RTM */
    Controller_Master_M->ModelData.blockIO = &Controller_Master_B;
    Controller_Master_M->ModelData.dwork = &Controller_Master_DW;
    Controller_Master_U_V = V;
    Controller_Master_U_D_M = 50;
    Controller_Master_U_Slave = 1;
    Controller_Master_U_QA_EN = true;

    /* Initialize model */
    Controller_Master_initialize(Controller_Master_M, &Controller_Master_U_V,
                                 &Controller_Master_U_D_M, &Controller_Master_U_Slave,
                                 &Controller_Master_U_QA_EN, &Controller_Master_Y_BRAKE,
                                 &Controller_Master_Y_ACC, &Controller_Master_Y_LED_RED,
                                 &Controller_Master_Y_LED_GREEN, &Controller_Master_Y_LED_BLUE,
                                 &Controller_Master_Y_MASTER);

    /* Attach rt_OneStep to a timer or interrupt service routine with
     * period 0.1 seconds (the model's base sample time) here.  The
     * call syntax for rt_OneStep is
     *
     *  rt_OneStep(Controller_Master_M);
     */

    led_B.write(1);
    led_G.write(1);
    led_R.write(1);
    qa.mode(PullDown);
    master_out = 1;
    acc = 0;
    brake = 0;
    t.attach(&step,0.1);

    while (true) {
        wait(0.2);
    }

    /* Disable rt_OneStep() here */

    /* Terminate model */
    Controller_Master_terminate(Controller_Master_M);
}

void step()
{
    int var = 0;
    char str[10];
    if(myrio.readable()) {
        myrio.scanf("%s",str);
        var = atoi(str);
        //pc.printf("%d \n",var);
    }
    V = var;
    Controller_Master_U_V = V;
    Controller_Master_U_D_M = sonic.read_cm();
    Controller_Master_U_Slave = 1;
    Controller_Master_U_QA_EN = qa;
    rt_OneStep(Controller_Master_M);
    master_out = Controller_Master_Y_MASTER;
    acc = Controller_Master_Y_ACC;
    brake = Controller_Master_Y_BRAKE;
    led_B = !Controller_Master_Y_LED_BLUE;         // negate because 1 -> led off
    led_R = !Controller_Master_Y_LED_RED;
    led_G = !Controller_Master_Y_LED_GREEN;
    pc.printf("distance: %f \n", Controller_Master_U_D_M);
    pc.printf("speed: %f \n", Controller_Master_U_V);
    /*    pc.printf("blue: %d \n", Controller_Master_Y_LED_BLUE);    // Call read_cm() to get the distance in cm
        pc.printf("red: %d \n", Controller_Master_Y_LED_RED);
        pc.printf("master: %d \n", Controller_Master_Y_MASTER);
        pc.printf("brake: %d \n", Controller_Master_Y_BRAKE);
        pc.printf("green: %d \n", Controller_Master_Y_LED_GREEN);
        pc.printf("acc: %d \n", Controller_Master_Y_ACC);
    */

}

void rt_OneStep(RT_MODEL_Controller_Master_T *const Controller_Master_M)
{
    static boolean_T OverrunFlag = false;

    /* Disable interrupts here */

    /* Check for overrun */
    if (OverrunFlag) {
        rtmSetErrorStatus(Controller_Master_M, "Overrun");
        return;
    }

    OverrunFlag = true;

    /* Save FPU context here (if necessary) */
    /* Re-enable timer or interrupt here */
    /* Set model inputs here */

    /* Step the model */
    Controller_Master_step(Controller_Master_M, Controller_Master_U_V,
                           Controller_Master_U_D_M, Controller_Master_U_QA_EN,
                           &Controller_Master_Y_BRAKE, &Controller_Master_Y_ACC,
                           &Controller_Master_Y_LED_RED, &Controller_Master_Y_LED_GREEN,
                           &Controller_Master_Y_LED_BLUE, &Controller_Master_Y_MASTER);

    /* Get model outputs here */

    /* Indicate task complete */
    OverrunFlag = false;

    /* Disable interrupts here */
    /* Restore FPU context here (if necessary) */
    /* Enable interrupts here */
}
