// Voltage resource implementation

#include "wattage.h"

#include "NSPio.h"
#include "MBEDWattage.h"

extern Logger *logger;

NSPio *wattage = NULL;

// observation support
static uint8_t wattage_obs_number = 0;
static uint8_t *wattage_obs_token_ptr = NULL;
static uint8_t wattage_obs_token_len = 0;

// send our wattage observation
void send_wattage_observation() {
    if (wattage_obs_token_ptr != NULL && wattage_obs_number != 0) {
        //if (m_logger != NULL) logger->log("Sending Observation (wattage): %s",wattage->resource()->getValuePointer());
        sn_nsdl_send_observation_notification(wattage_obs_token_ptr,wattage_obs_token_len,(uint8_t*)wattage->resource()->getValuePointer(),strlen(wattage->resource()->getValuePointer()),&wattage_obs_number,sizeof(wattage_obs_number),COAP_MSG_TYPE_NON_CONFIRMABLE, 0);
    }
}

// init wattage
void init_wattage(Resource *resource) {
    if (wattage == NULL && resource != NULL) wattage = new NSPio(new MBEDWattage(m_logger,resource),&send_wattage_observation);
}

// update our wattage observation
void update_wattage_observation(sn_coap_hdr_s *received_coap_ptr,sn_coap_hdr_s *coap_res_ptr) {
    //if (m_logger != NULL) logger->log("Updating Observation (wattage)...starting");
    if (received_coap_ptr->token_ptr != NULL) {
        if (wattage_obs_token_ptr != NULL) free(wattage_obs_token_ptr);
        wattage_obs_token_ptr = (uint8_t *)malloc(received_coap_ptr->token_len);
        if(wattage_obs_token_ptr != NULL) {
            memcpy(wattage_obs_token_ptr, received_coap_ptr->token_ptr, received_coap_ptr->token_len);
            wattage_obs_token_len = received_coap_ptr->token_len;
        }
    }
    if (received_coap_ptr->options_list_ptr->observe != NULL) {
        coap_res_ptr->options_list_ptr = (sn_coap_options_list_s*)malloc(sizeof(sn_coap_options_list_s));
        memset(coap_res_ptr->options_list_ptr, 0, sizeof(sn_coap_options_list_s));
        coap_res_ptr->options_list_ptr->observe_ptr = &(wattage_obs_number);
        coap_res_ptr->options_list_ptr->observe_len = 1;
        wattage_obs_number++;
    }
    //if (m_logger != NULL) logger->log("Updating Observation (wattage)...done");
}

/* Only GET method allowed */
uint8_t wattage_cb(sn_coap_hdr_s *received_coap_ptr, sn_nsdl_addr_s *address, sn_proto_info_s *proto) {
    return nsp_get("wattage",wattage,received_coap_ptr,address,proto,&update_wattage_observation);
}