// Voltage resource implementation

#include "voltage.h"

#include "NSPio.h"
#include "MBEDVoltage.h"

extern Logger *logger;

NSPio *voltage = NULL;

// observation support
static uint8_t voltage_obs_number = 0;
static uint8_t *voltage_obs_token_ptr = NULL;
static uint8_t voltage_obs_token_len = 0;

// send our voltage observation
void send_voltage_observation() {
    if (voltage_obs_token_ptr != NULL && voltage_obs_number != 0) {
        //if (m_logger != NULL) m_logger->log("Sending Observation (voltage): %s",voltage->resource()->getValuePointer());
        sn_nsdl_send_observation_notification(voltage_obs_token_ptr,voltage_obs_token_len,(uint8_t*)voltage->resource()->getValuePointer(),strlen(voltage->resource()->getValuePointer()),&voltage_obs_number,sizeof(voltage_obs_number),COAP_MSG_TYPE_NON_CONFIRMABLE, 0);
    }
}

// init voltage
void init_voltage(Resource *resource) {
    if (voltage == NULL && resource != NULL) voltage = new NSPio(new MBEDVoltage(m_logger,resource),&send_voltage_observation);
}

// update our voltage observation
void update_voltage_observation(sn_coap_hdr_s *received_coap_ptr,sn_coap_hdr_s *coap_res_ptr) {
    //if (m_logger != NULL) m_logger->log("Updating Observation (voltage)...starting");
    if (received_coap_ptr->token_ptr != NULL) {
        if (voltage_obs_token_ptr != NULL) free(voltage_obs_token_ptr);
        voltage_obs_token_ptr = (uint8_t *)malloc(received_coap_ptr->token_len);
        if(voltage_obs_token_ptr != NULL) {
            memcpy(voltage_obs_token_ptr, received_coap_ptr->token_ptr, received_coap_ptr->token_len);
            voltage_obs_token_len = received_coap_ptr->token_len;
        }
    }
    if (received_coap_ptr->options_list_ptr->observe != NULL) {
        coap_res_ptr->options_list_ptr = (sn_coap_options_list_s*)malloc(sizeof(sn_coap_options_list_s));
        memset(coap_res_ptr->options_list_ptr, 0, sizeof(sn_coap_options_list_s));
        coap_res_ptr->options_list_ptr->observe_ptr = &(voltage_obs_number);
        coap_res_ptr->options_list_ptr->observe_len = 1;
        voltage_obs_number++;
    }
    //if (m_logger != NULL) m_logger->log("Updating Observation (voltage)...done");
}

/* Only GET method allowed */
uint8_t voltage_cb(sn_coap_hdr_s *received_coap_ptr, sn_nsdl_addr_s *address, sn_proto_info_s *proto) {
    return nsp_get("voltage",voltage,received_coap_ptr,address,proto,&update_voltage_observation);
}