#include "nsp_get.h"

extern char *strdup(char *str);

// NSP Get Method
uint8_t nsp_get(char *tag,MBEDio *io,sn_coap_hdr_s *received_coap_ptr, sn_nsdl_addr_s *address, sn_proto_info_s *proto) { return nsp_get(tag,io,received_coap_ptr,address,proto,NULL); }
uint8_t nsp_get(char *tag,MBEDio *io,sn_coap_hdr_s *received_coap_ptr, sn_nsdl_addr_s *address, sn_proto_info_s *proto,sn_update_observation_t observer) {
if (m_logger != NULL) m_logger->log_memory("NSP GET MEMORY CHECK(begin)");
#ifdef NSP_ENABLE_GET
    //if (m_logger != NULL) m_logger->log("NSP: %s requested",tag);
    sn_coap_hdr_s *coap_res_ptr = NULL;
    coap_res_ptr = sn_coap_build_response(received_coap_ptr,COAP_MSG_CODE_RESPONSE_CONTENT);
    if (coap_res_ptr != NULL && io != NULL && io->stringValue() != NULL) {      // io->stringValue() refreshes the value
        coap_res_ptr->msg_type = COAP_MSG_TYPE_CONFIRMABLE;
        coap_res_ptr->payload_len = strlen(io->resource()->getValuePointer());
        coap_res_ptr->payload_ptr = (uint8_t*)io->resource()->getValuePointer();
        //if (m_logger != NULL) m_logger->log("NSP: Sending %s = %s...",tag,io->resource()->getValuePointer());
        if (observer != NULL) (observer)(received_coap_ptr,coap_res_ptr);
        sn_nsdl_send_coap_message(address, coap_res_ptr);
        if (m_logger != NULL) m_logger->log("NSP: Sent %s = %s...",tag,io->resource()->getValuePointer());
    }
    else if (coap_res_ptr == NULL) {
        if (m_logger != NULL) m_logger->log("NSP: %s request: coap_res_ptr is NULL!",tag);
    }
    else {
        if (m_logger != NULL) m_logger->log("NSP: %s request: MBEDio is NULL!",tag);
    }
    if (coap_res_ptr != NULL && coap_res_ptr->options_list_ptr != NULL) coap_res_ptr->options_list_ptr->observe_ptr = NULL;
    if (coap_res_ptr != NULL) sn_coap_parser_release_allocated_coap_msg_mem(coap_res_ptr);
    if (m_logger != NULL) m_logger->log_memory("NSP GET MEMORY CHECK(done)");
    return 0;
#else
    if (m_logger != NULL) m_logger->log("NSP Get() functions disabled for %s",tag);
    if (m_logger != NULL) m_logger->log_memory("NSP GET MEMORY CHECK(off)");
    return 0;
#endif
}