// dimmer resource implementation

#include "mbed.h"
#include "nsdl_support.h"
#include "dimmer.h"
#include "NSPLightDimmerAction.h"
#include "NSPio.h"

extern Logger *logger;
extern NSPLightDimmerAction *_dimmerAction;

NSPio *dimmer = NULL;

// observation support
static uint8_t dimmer_obs_number = 0;
static uint8_t *dimmer_obs_token_ptr = NULL;
static uint8_t dimmer_obs_token_len = 0;

// send our dimmer observation
void send_dimmer_observation() {
    if (dimmer_obs_token_ptr != NULL && dimmer_obs_number != 0) {
        //if (m_logger != NULL) m_logger->log("Sending Observation (dimmer): %s",dimmer->resource()->getValuePointer());
        sn_nsdl_send_observation_notification(dimmer_obs_token_ptr,dimmer_obs_token_len,(uint8_t*)dimmer->resource()->getValuePointer(),strlen(dimmer->resource()->getValuePointer()),&dimmer_obs_number,sizeof(dimmer_obs_number),COAP_MSG_TYPE_NON_CONFIRMABLE, 0);
    }
}

// init dimmer
void init_dimmer(Resource *resource) {
    if (dimmer == NULL && resource != NULL) dimmer = new NSPio(m_logger,resource,&send_dimmer_observation);
}

// update our dimmer observation
void update_dimmer_observation(sn_coap_hdr_s *received_coap_ptr,sn_coap_hdr_s *coap_res_ptr) {
    //if (m_logger != NULL) m_logger->log("Updating Observation (dimmer)...starting");
    if (received_coap_ptr->token_ptr != NULL) {
        if (dimmer_obs_token_ptr != NULL) free(dimmer_obs_token_ptr);
        dimmer_obs_token_ptr = (uint8_t *)malloc(received_coap_ptr->token_len);
        if(dimmer_obs_token_ptr != NULL) {
            memcpy(dimmer_obs_token_ptr, received_coap_ptr->token_ptr, received_coap_ptr->token_len);
            dimmer_obs_token_len = received_coap_ptr->token_len;
        }
    }
    if (received_coap_ptr->options_list_ptr->observe != NULL) {
        coap_res_ptr->options_list_ptr = (sn_coap_options_list_s*)malloc(sizeof(sn_coap_options_list_s));
        memset(coap_res_ptr->options_list_ptr, 0, sizeof(sn_coap_options_list_s));
        coap_res_ptr->options_list_ptr->observe_ptr = &(dimmer_obs_number);
        coap_res_ptr->options_list_ptr->observe_len = 1;
        dimmer_obs_number++;
    }
    //if (m_logger != NULL) m_logger->log("Updating Observation (dimmer)...done");
}

/* Only GET and PUT method allowed */
uint8_t dimmer_cb(sn_coap_hdr_s *received_coap_ptr, sn_nsdl_addr_s *address, sn_proto_info_s * proto) {
    uint8_t result = nsp_getput("dimmer",dimmer,received_coap_ptr,address,proto,&update_dimmer_observation);
    
    // action upon it...
    if (result == 0 && _dimmerAction != NULL) _dimmerAction->dim(dimmer->intValue());
        
    return result;
 }