// light_sw resource implementation

#include "mbed.h"
#include "nsdl_support.h"
#include "switch.h"
#include "NSPLightSwitchAction.h"
#include "NSPio.h"

extern Logger *logger;
extern NSPLightSwitchAction *_switchAction;

NSPio *light_sw = NULL;

// observation support
static uint8_t light_sw_obs_number = 0;
static uint8_t *light_sw_obs_token_ptr = NULL;
static uint8_t light_sw_obs_token_len = 0;

// send our light_sw observation
void send_light_sw_observation() {
    if (light_sw_obs_token_ptr != NULL && light_sw_obs_number != 0) {
        //if (m_logger != NULL) m_logger->log("Sending Observation (switch): %s",light_sw->resource()->getValuePointer());
        sn_nsdl_send_observation_notification(light_sw_obs_token_ptr,light_sw_obs_token_len,(uint8_t*)light_sw->resource()->getValuePointer(),strlen(light_sw->resource()->getValuePointer()),&light_sw_obs_number,sizeof(light_sw_obs_number),COAP_MSG_TYPE_NON_CONFIRMABLE, 0);
    }
}

// init light switch
void init_switch(Resource *resource) {
    if (light_sw == NULL && resource != NULL) light_sw = new NSPio(m_logger,resource,&send_light_sw_observation);
}


// update our light_sw observation
void update_light_sw_observation(sn_coap_hdr_s *received_coap_ptr,sn_coap_hdr_s *coap_res_ptr) {
    //if (m_logger != NULL) m_logger->log("Updating Observation (switch)...starting");
    if (received_coap_ptr->token_ptr != NULL) {
        if (light_sw_obs_token_ptr != NULL) free(light_sw_obs_token_ptr);
        light_sw_obs_token_ptr = (uint8_t *)malloc(received_coap_ptr->token_len);
        if(light_sw_obs_token_ptr != NULL) {
            memcpy(light_sw_obs_token_ptr, received_coap_ptr->token_ptr, received_coap_ptr->token_len);
            light_sw_obs_token_len = received_coap_ptr->token_len;
        }
    }
    if (received_coap_ptr->options_list_ptr->observe != NULL) {
        coap_res_ptr->options_list_ptr = (sn_coap_options_list_s*)malloc(sizeof(sn_coap_options_list_s));
        memset(coap_res_ptr->options_list_ptr, 0, sizeof(sn_coap_options_list_s));
        coap_res_ptr->options_list_ptr->observe_ptr = &(light_sw_obs_number);
        coap_res_ptr->options_list_ptr->observe_len = 1;
        light_sw_obs_number++;
    }
    //if (m_logger != NULL) m_logger->log("Updating Observation (switch)...done");
}

/* Only GET and PUT method allowed */
uint8_t switch_cb(sn_coap_hdr_s *received_coap_ptr, sn_nsdl_addr_s *address, sn_proto_info_s * proto) {
    uint8_t result = nsp_getput("switch",light_sw,received_coap_ptr,address,proto,&update_light_sw_observation);
    
    // action upon it...
    if (result == 0 && _switchAction != NULL) {
        if (light_sw->intValue() == 1)
            _switchAction->on();
        else if (light_sw->intValue() == 2)
            _switchAction->blink();
        else
            _switchAction->off();
    }
        
    return result;
}