// mfg text resource implementation

#include "mfgtext.h"

#include "NSPio.h"

extern Logger *logger;
NSPio *mfgtext = NULL;

// observation support
static uint8_t mfgtext_obs_number = 0;
static uint8_t *mfgtext_obs_token_ptr = NULL;
static uint8_t mfgtext_obs_token_len = 0;

// send our mfgtext observation
void send_mfgtext_observation() {
    if (mfgtext_obs_token_ptr != NULL && mfgtext_obs_number != 0) {
        //if (m_logger != NULL) m_logger->log("Sending Observation (mfgtext): %s",mfgtext->resource()->getValuePointer());
        sn_nsdl_send_observation_notification(mfgtext_obs_token_ptr,mfgtext_obs_token_len,(uint8_t*)mfgtext->resource()->getValuePointer(),strlen(mfgtext->resource()->getValuePointer()),&mfgtext_obs_number,sizeof(mfgtext_obs_number),COAP_MSG_TYPE_NON_CONFIRMABLE, 0);
    }
}

// init mfgtext
void init_mfgtext(Resource *resource) {
    if (mfgtext == NULL && resource != NULL) mfgtext = new NSPio(m_logger,resource,&send_mfgtext_observation);
}

// update our mfgtext observation
void update_mfgtext_observation(sn_coap_hdr_s *received_coap_ptr,sn_coap_hdr_s *coap_res_ptr) {
    //if (m_logger != NULL) m_logger->log("Updating Observation (mfgtext)...starting");
    if (received_coap_ptr->token_ptr != NULL) {
        if (mfgtext_obs_token_ptr != NULL) free(mfgtext_obs_token_ptr);
        mfgtext_obs_token_ptr = (uint8_t *)malloc(received_coap_ptr->token_len);
        if(mfgtext_obs_token_ptr != NULL) {
            memcpy(mfgtext_obs_token_ptr, received_coap_ptr->token_ptr, received_coap_ptr->token_len);
            mfgtext_obs_token_len = received_coap_ptr->token_len;
        }
    }
    if (received_coap_ptr->options_list_ptr->observe != NULL) {
        coap_res_ptr->options_list_ptr = (sn_coap_options_list_s*)malloc(sizeof(sn_coap_options_list_s));
        memset(coap_res_ptr->options_list_ptr, 0, sizeof(sn_coap_options_list_s));
        coap_res_ptr->options_list_ptr->observe_ptr = &(mfgtext_obs_number);
        coap_res_ptr->options_list_ptr->observe_len = 1;
        mfgtext_obs_number++;
    }
    //if (m_logger != NULL) m_logger->log("Updating Observation (mfgtext)...done");
}

/* Only GET method allowed */
uint8_t mfgtext_cb(sn_coap_hdr_s *received_coap_ptr, sn_nsdl_addr_s *address, sn_proto_info_s *proto) {
    return nsp_get("mfgtext",mfgtext,received_coap_ptr,address,proto,&update_mfgtext_observation);
}