// mdl text resource implementation

#include "mdltext.h"

#include "NSPio.h"

extern Logger *logger;
NSPio *mdltext = NULL;

// observation support
static uint8_t mdltext_obs_number = 0;
static uint8_t *mdltext_obs_token_ptr = NULL;
static uint8_t mdltext_obs_token_len = 0;

// send our mdltext observation
void send_mdltext_observation() {
    if (mdltext_obs_token_ptr != NULL && mdltext_obs_number != 0) {
        //if (m_logger != NULL) m_logger->log("Sending Observation (mdltext): %s",mdltext->resource()->getValuePointer());
        sn_nsdl_send_observation_notification(mdltext_obs_token_ptr,mdltext_obs_token_len,(uint8_t*)mdltext->resource()->getValuePointer(),strlen(mdltext->resource()->getValuePointer()),&mdltext_obs_number,sizeof(mdltext_obs_number),COAP_MSG_TYPE_NON_CONFIRMABLE, 0);
    }
}

// init mdltext
void init_mdltext(Resource *resource) {
    if (mdltext == NULL && resource != NULL) mdltext = new NSPio(m_logger,resource,&send_mdltext_observation);
}

// update our mdltext observation
void update_mdltext_observation(sn_coap_hdr_s *received_coap_ptr,sn_coap_hdr_s *coap_res_ptr) {
    //if (m_logger != NULL) m_logger->log("Updating Observation (mdltext)...starting");
    if (received_coap_ptr->token_ptr != NULL) {
        if (mdltext_obs_token_ptr != NULL) free(mdltext_obs_token_ptr);
        mdltext_obs_token_ptr = (uint8_t *)malloc(received_coap_ptr->token_len);
        if(mdltext_obs_token_ptr != NULL) {
            memcpy(mdltext_obs_token_ptr, received_coap_ptr->token_ptr, received_coap_ptr->token_len);
            mdltext_obs_token_len = received_coap_ptr->token_len;
        }
    }
    if (received_coap_ptr->options_list_ptr->observe != NULL) {
        coap_res_ptr->options_list_ptr = (sn_coap_options_list_s*)malloc(sizeof(sn_coap_options_list_s));
        memset(coap_res_ptr->options_list_ptr, 0, sizeof(sn_coap_options_list_s));
        coap_res_ptr->options_list_ptr->observe_ptr = &(mdltext_obs_number);
        coap_res_ptr->options_list_ptr->observe_len = 1;
        mdltext_obs_number++;
    }
    //if (m_logger != NULL) m_logger->log("Updating Observation (mdltext)...done");
}

/* Only GET method allowed */
uint8_t mdltext_cb(sn_coap_hdr_s *received_coap_ptr, sn_nsdl_addr_s *address, sn_proto_info_s *proto) {
    return nsp_get("mdltext",mdltext,received_coap_ptr,address,proto,&update_mdltext_observation);
}