// gps resource implementation

#include "gps.h"

#include "NSPio.h"
#include "MBEDgps.h"

extern Logger *logger;
NSPio *nsp_gps = NULL;

// observation support
static uint8_t gps_obs_number = 0;
static uint8_t *gps_obs_token_ptr = NULL;
static uint8_t gps_obs_token_len = 0;

// send our gps observation
void send_gps_observation() {
    if (gps_obs_token_ptr != NULL && gps_obs_number != 0) {
        //if (m_logger != NULL) m_logger->log("Sending Observation (gps): %s",gps->resource()->getValuePointer());
        sn_nsdl_send_observation_notification(gps_obs_token_ptr,gps_obs_token_len,(uint8_t*)nsp_gps->resource()->getValuePointer(),strlen(nsp_gps->resource()->getValuePointer()),&gps_obs_number,sizeof(gps_obs_number),COAP_MSG_TYPE_NON_CONFIRMABLE, 0);
    }
}

// init gps
void init_gps(Resource *resource) {
    if (nsp_gps == NULL && resource != NULL) nsp_gps = new NSPio(new MBEDgps(m_logger,resource),&send_gps_observation);
}

// update our gps observation
void update_gps_observation(sn_coap_hdr_s *received_coap_ptr,sn_coap_hdr_s *coap_res_ptr) {
    //if (m_logger != NULL) m_logger->log("Updating Observation (gps)...starting");
    if (received_coap_ptr->token_ptr != NULL) {
        if (gps_obs_token_ptr != NULL) free(gps_obs_token_ptr);
        gps_obs_token_ptr = (uint8_t *)malloc(received_coap_ptr->token_len);
        if(gps_obs_token_ptr != NULL) {
            memcpy(gps_obs_token_ptr, received_coap_ptr->token_ptr, received_coap_ptr->token_len);
            gps_obs_token_len = received_coap_ptr->token_len;
        }
    }
    if (received_coap_ptr->options_list_ptr->observe != NULL) {
        coap_res_ptr->options_list_ptr = (sn_coap_options_list_s*)malloc(sizeof(sn_coap_options_list_s));
        memset(coap_res_ptr->options_list_ptr, 0, sizeof(sn_coap_options_list_s));
        coap_res_ptr->options_list_ptr->observe_ptr = &(gps_obs_number);
        coap_res_ptr->options_list_ptr->observe_len = 1;
        gps_obs_number++;
    }
    //if (m_logger != NULL) m_logger->log("Updating Observation (gps)...done");
}

/* Only GET method allowed */
uint8_t gps_location_cb(sn_coap_hdr_s *received_coap_ptr, sn_nsdl_addr_s *address, sn_proto_info_s *proto) {
    return nsp_get("gps",nsp_gps,received_coap_ptr,address,proto,&update_gps_observation);
}