// Current resource implementation

#include "current.h"

#include "NSPio.h"
#include "MBEDCurrent.h"

extern Logger *logger;
NSPio *current = NULL;

// observation support
static uint8_t current_obs_number = 0;
static uint8_t *current_obs_token_ptr = NULL;
static uint8_t current_obs_token_len = 0;

// send our current observation
void send_current_observation() {
    if (current_obs_token_ptr != NULL && current_obs_number != 0) {
        //if (m_logger != NULL) m_logger->log("Sending Observation (current): %s",current->resource()->getValuePointer());
        sn_nsdl_send_observation_notification(current_obs_token_ptr,current_obs_token_len,(uint8_t*)current->resource()->getValuePointer(),strlen(current->resource()->getValuePointer()),&current_obs_number,sizeof(current_obs_number),COAP_MSG_TYPE_NON_CONFIRMABLE, 0);
    }
}

// init current
void init_current(Resource *resource) {
    if (current == NULL && resource != NULL) current = new NSPio(new MBEDCurrent(m_logger,resource),&send_current_observation);
}

// update our current observation
void update_current_observation(sn_coap_hdr_s *received_coap_ptr,sn_coap_hdr_s *coap_res_ptr) {
    //if (m_logger != NULL) m_logger->log("Updating Observation (current)...starting");
    if (received_coap_ptr->token_ptr != NULL) {
        if (current_obs_token_ptr != NULL) free(current_obs_token_ptr);
        current_obs_token_ptr = (uint8_t *)malloc(received_coap_ptr->token_len);
        if(current_obs_token_ptr != NULL) {
            memcpy(current_obs_token_ptr, received_coap_ptr->token_ptr, received_coap_ptr->token_len);
            current_obs_token_len = received_coap_ptr->token_len;
        }
    }
    if (received_coap_ptr->options_list_ptr->observe != NULL) {
        coap_res_ptr->options_list_ptr = (sn_coap_options_list_s*)malloc(sizeof(sn_coap_options_list_s));
        memset(coap_res_ptr->options_list_ptr, 0, sizeof(sn_coap_options_list_s));
        coap_res_ptr->options_list_ptr->observe_ptr = &(current_obs_number);
        coap_res_ptr->options_list_ptr->observe_len = 1;
        current_obs_number++;
    }
    //if (m_logger != NULL) m_logger->log("Updating Observation (current)...done");
}

/* Only GET method allowed */
uint8_t current_cb(sn_coap_hdr_s *received_coap_ptr, sn_nsdl_addr_s *address, sn_proto_info_s *proto) {
    return nsp_get("current",current,received_coap_ptr,address,proto,&update_current_observation);
}