// rssi resource implementation

#include "rssi.h"

#include "NSPio.h"
#include "MBEDrssi.h"

extern Logger *logger;
NSPio *rssi = NULL;

// observation support
static uint8_t rssi_obs_number = 0;
static uint8_t *rssi_obs_token_ptr = NULL;
static uint8_t rssi_obs_token_len = 0;

// send our rssi observation
void send_rssi_observation() {
    if (rssi_obs_token_ptr != NULL && rssi_obs_number != 0) {
        //if (m_logger != NULL) m_logger->log("Sending Observation (rssi): %s",rssi->resource()->getValuePointer());
        sn_nsdl_send_observation_notification(rssi_obs_token_ptr,rssi_obs_token_len,(uint8_t*)rssi->resource()->getValuePointer(),strlen(rssi->resource()->getValuePointer()),&rssi_obs_number,sizeof(rssi_obs_number),COAP_MSG_TYPE_NON_CONFIRMABLE, 0);
    }
}

// init rssi
void init_rssi(Resource *resource) {
    if (rssi == NULL && resource != NULL) rssi = new NSPio(new MBEDrssi(m_logger,resource),&send_rssi_observation);
}

// update our rssi observation
void update_rssi_observation(sn_coap_hdr_s *received_coap_ptr,sn_coap_hdr_s *coap_res_ptr) {
    //if (m_logger != NULL) m_logger->log("Updating Observation (rssi)...starting");
    if (received_coap_ptr->token_ptr != NULL) {
        if (rssi_obs_token_ptr != NULL) free(rssi_obs_token_ptr);
        rssi_obs_token_ptr = (uint8_t *)malloc(received_coap_ptr->token_len);
        if(rssi_obs_token_ptr != NULL) {
            memcpy(rssi_obs_token_ptr, received_coap_ptr->token_ptr, received_coap_ptr->token_len);
            rssi_obs_token_len = received_coap_ptr->token_len;
        }
    }
    if (received_coap_ptr->options_list_ptr->observe != NULL) {
        coap_res_ptr->options_list_ptr = (sn_coap_options_list_s*)malloc(sizeof(sn_coap_options_list_s));
        memset(coap_res_ptr->options_list_ptr, 0, sizeof(sn_coap_options_list_s));
        coap_res_ptr->options_list_ptr->observe_ptr = &(rssi_obs_number);
        coap_res_ptr->options_list_ptr->observe_len = 1;
        rssi_obs_number++;
    }
    //if (m_logger != NULL) m_logger->log("Updating Observation (rssi)...done");
}

/* Only GET method allowed */
uint8_t rssi_cb(sn_coap_hdr_s *received_coap_ptr, sn_nsdl_addr_s *address, sn_proto_info_s *proto) {
    return nsp_get("rssi",rssi,received_coap_ptr,address,proto,&update_rssi_observation);
}