#include "nsp_getput.h"

extern char *strdup(char *str);

// NSP Get/Put Method
uint8_t nsp_getput(char *tag,NSPio *io,sn_coap_hdr_s *received_coap_ptr, sn_nsdl_addr_s *address, sn_proto_info_s *proto) { return nsp_getput(tag,io,received_coap_ptr,address,proto,NULL); }
uint8_t nsp_getput(char *tag,NSPio *io,sn_coap_hdr_s *received_coap_ptr, sn_nsdl_addr_s *address, sn_proto_info_s *proto,sn_update_observation_t observer) {
if (m_logger != NULL) m_logger->log_memory("NSP GETPUT MEMORY CHECK(begin)");
#ifdef NSP_ENABLE_GETPUT
    sn_coap_hdr_s *coap_res_ptr = NULL;
    bool is_get = false;

    if(received_coap_ptr->msg_code == COAP_MSG_CODE_REQUEST_GET)
    {
        //if (m_logger != NULL) m_logger->log("NSP: %s requested",tag);
        coap_res_ptr = sn_coap_build_response(received_coap_ptr, COAP_MSG_CODE_RESPONSE_CONTENT);
        if (coap_res_ptr != NULL && io != NULL && io->stringValue() != NULL) {      // io->stringValue() refreshes the value
            coap_res_ptr->msg_type = COAP_MSG_TYPE_CONFIRMABLE;
            coap_res_ptr->payload_len = strlen(io->resource()->getValuePointer());
            coap_res_ptr->payload_ptr = (uint8_t*)io->resource()->getValuePointer();
            //if (m_logger != NULL) m_logger->log("NSP: Sending %s = %s...",tag,io->resource()->getValuePointer());
            if (observer != NULL) (observer)(received_coap_ptr,coap_res_ptr);
            sn_nsdl_send_coap_message(address, coap_res_ptr);
            if (m_logger != NULL) m_logger->log("NSP: Sent %s = %s...",tag,io->resource()->getValuePointer());
        }
        else if (coap_res_ptr == NULL) {
            if (m_logger != NULL) m_logger->log("NSP: %s location request: coap_res_ptr is NULL!",tag);
        }
        else {
            if (m_logger != NULL) m_logger->log("NSP: %s location request: NSPio is NULL!",tag);
        }
        is_get = true;
    }
    else if(received_coap_ptr->msg_code == COAP_MSG_CODE_REQUEST_PUT)
    {   //if (m_logger != NULL) m_logger->log("NSP: setting %s",tag);
        // copy the new value
        if (io->resource() != NULL && received_coap_ptr->payload_ptr != NULL && received_coap_ptr->payload_len > 0) {
            io->resource()->setValue((char *)received_coap_ptr->payload_ptr,received_coap_ptr->payload_len);
            if (m_logger != NULL) m_logger->log("NSP: set %s to %s...",tag,io->resource()->getValuePointer());
        }
        else {
            if (m_logger != NULL) m_logger->log("NSP: %s resource pointer is NULL",tag);
        }
        
        // response back
        coap_res_ptr = sn_coap_build_response(received_coap_ptr, COAP_MSG_CODE_RESPONSE_CHANGED);
        sn_nsdl_send_coap_message(address, coap_res_ptr);
    }
    if (is_get && coap_res_ptr != NULL && coap_res_ptr->options_list_ptr != NULL) coap_res_ptr->options_list_ptr->observe_ptr = NULL;
    if (coap_res_ptr != NULL) sn_coap_parser_release_allocated_coap_msg_mem(coap_res_ptr);
    if (m_logger != NULL) m_logger->log_memory("NSP GETPUT MEMORY CHECK(done)");
    return 0;
#else
    if (m_logger != NULL) m_logger->log("NSP GetPut() functions disabled for %s",tag);
    if (m_logger != NULL) m_logger->log_memory("NSP GETPUT MEMORY CHECK(off)");
    return 0;
#endif
}