// Support functions for the NSDL library

#ifndef NSDL_SUPPORT_H
#define NSDL_SUPPORT_H

#include "Logger.h"

#ifndef CELLULAR_NETWORK
#include "EthernetInterface.h"
#endif

#include "mbed.h"
#include <stdint.h>
#include "sn_nsdl.h"
#include "sn_coap_header.h"
#include "sn_coap_protocol.h"
#include "sn_nsdl_lib.h"

typedef uint8_t (*sn_grs_dyn_res_callback_t)(sn_coap_hdr_s *, sn_nsdl_addr_s *, sn_proto_info_s *);
typedef void (*sn_update_observation_t)(sn_coap_hdr_s *,sn_coap_hdr_s *);

extern "C" void *nsdl_alloc(uint16_t size);
extern "C" void nsdl_free(void* ptr_to_free);
void nsdl_create_static_resource(sn_nsdl_resource_info_s *resource_structure, uint16_t pt_len, uint8_t *pt, uint16_t rpp_len, uint8_t *rpp_ptr, uint16_t if_len, uint8_t *if_ptr, uint8_t is_observable, uint8_t is_registered, uint8_t *rsc, uint16_t rsc_len);
void nsdl_create_dynamic_resource(sn_nsdl_resource_info_s *resource_structure, uint16_t pt_len, uint8_t *pt, uint16_t rpp_len, uint8_t *rpp_ptr, uint16_t if_len, uint8_t *if_ptr, uint8_t is_observable, uint8_t is_registered,  sn_grs_dyn_res_callback_t callback_ptr, int access_right);
sn_nsdl_ep_parameters_s* nsdl_init_register_endpoint(sn_nsdl_ep_parameters_s *endpoint_structure, uint8_t* name, uint8_t* ypename_ptr, uint8_t *lifetime_ptr);
void nsdl_clean_register_endpoint(sn_nsdl_ep_parameters_s **endpoint_structure);
void nsdl_init();
void nsdl_event_loop();

extern uint8_t _ep_type[];
extern uint8_t _lifetime_ptr[];
extern char _endpoint_name[PERSONALITY_NAME_LEN+1];

#ifdef CELLULAR_NETWORK
#ifdef NETWORK_MUTEX
    #include "rtos.h"
#endif
    #include "UDPSocket.h"
    #include "Endpoint.h"
#endif

extern Endpoint nsp;
extern UDPSocket server;

#ifndef CELLULAR_NETWORK
    #include "EthernetInterface.h"
    extern EthernetInterface ethernet;
#endif
extern Logger *m_logger;

#endif // NSDL_SUPPORT_H
