// location text resource implementation

#include "locationtext.h"

#include "NSPio.h"

extern Logger *logger;
NSPio *locationtext = NULL;

// observation support
static uint8_t locationtext_obs_number = 0;
static uint8_t *locationtext_obs_token_ptr = NULL;
static uint8_t locationtext_obs_token_len = 0;

// send our locationtext observation
void send_locationtext_observation() {
    if (locationtext_obs_token_ptr != NULL && locationtext_obs_number != 0) {
        //if (m_logger != NULL) m_logger->log("Sending Observation (locationtext): %s",locationtext->resource()->getValuePointer());
        sn_nsdl_send_observation_notification(locationtext_obs_token_ptr,locationtext_obs_token_len,(uint8_t*)locationtext->resource()->getValuePointer(),strlen(locationtext->resource()->getValuePointer()),&locationtext_obs_number,sizeof(locationtext_obs_number),COAP_MSG_TYPE_NON_CONFIRMABLE, 0);
    }
}

// init locationtext
void init_locationtext(Resource *resource) {
    if (locationtext == NULL && resource != NULL) locationtext = new NSPio(m_logger,resource,&send_locationtext_observation);
}

// update our locationtext observation
void update_locationtext_observation(sn_coap_hdr_s *received_coap_ptr,sn_coap_hdr_s *coap_res_ptr) {
    //if (m_logger != NULL) m_logger->log("Updating Observation (locationtext)...starting");
    if (received_coap_ptr->token_ptr != NULL) {
        if (locationtext_obs_token_ptr != NULL) free(locationtext_obs_token_ptr);
        locationtext_obs_token_ptr = (uint8_t *)malloc(received_coap_ptr->token_len);
        if(locationtext_obs_token_ptr != NULL) {
            memcpy(locationtext_obs_token_ptr, received_coap_ptr->token_ptr, received_coap_ptr->token_len);
            locationtext_obs_token_len = received_coap_ptr->token_len;
        }
    }
    if (received_coap_ptr->options_list_ptr->observe != NULL) {
        coap_res_ptr->options_list_ptr = (sn_coap_options_list_s*)malloc(sizeof(sn_coap_options_list_s));
        memset(coap_res_ptr->options_list_ptr, 0, sizeof(sn_coap_options_list_s));
        coap_res_ptr->options_list_ptr->observe_ptr = &(locationtext_obs_number);
        coap_res_ptr->options_list_ptr->observe_len = 1;
        locationtext_obs_number++;
    }
    //if (m_logger != NULL) m_logger->log("Updating Observation (locationtext)...done");
}

/* Only GET method allowed */
uint8_t locationtext_cb(sn_coap_hdr_s *received_coap_ptr, sn_nsdl_addr_s *address, sn_proto_info_s *proto) {
    return nsp_get("locationtext",locationtext,received_coap_ptr,address,proto,&update_locationtext_observation);
}