// Battery resource implementation

#include "battery.h"

#include "NSPio.h"
#include "MBEDBattery.h"

extern Logger *logger;
NSPio *battery = NULL;

// observation support
static uint8_t battery_obs_number = 0;
static uint8_t *battery_obs_token_ptr = NULL;
static uint8_t battery_obs_token_len = 0;

// send our battery observation
void send_battery_observation() {
    if (battery_obs_token_ptr != NULL && battery_obs_number != 0) {
        //if (m_logger != NULL) m_logger->log("Sending Observation (battery): %s",battery->resource()->getValuePointer());
        sn_nsdl_send_observation_notification(battery_obs_token_ptr,battery_obs_token_len,(uint8_t*)battery->resource()->getValuePointer(),strlen(battery->resource()->getValuePointer()),&battery_obs_number,sizeof(battery_obs_number),COAP_MSG_TYPE_NON_CONFIRMABLE, 0);
    }
}

// init battery
void init_battery(Resource *resource) {
    if (battery == NULL && resource != NULL) battery = new NSPio(new MBEDBattery(m_logger,resource),&send_battery_observation);
}

// update our battery observation
void update_battery_observation(sn_coap_hdr_s *received_coap_ptr,sn_coap_hdr_s *coap_res_ptr) {
    //if (m_logger != NULL) m_logger->log("Updating Observation (batter)...starting");
    if (received_coap_ptr->token_ptr != NULL) {
        if (battery_obs_token_ptr != NULL) free(battery_obs_token_ptr);
        battery_obs_token_ptr = (uint8_t *)malloc(received_coap_ptr->token_len);
        if(battery_obs_token_ptr != NULL) {
            memcpy(battery_obs_token_ptr, received_coap_ptr->token_ptr, received_coap_ptr->token_len);
            battery_obs_token_len = received_coap_ptr->token_len;
        }
    }
    if (received_coap_ptr->options_list_ptr->observe != NULL) {
        coap_res_ptr->options_list_ptr = (sn_coap_options_list_s*)malloc(sizeof(sn_coap_options_list_s));
        memset(coap_res_ptr->options_list_ptr, 0, sizeof(sn_coap_options_list_s));
        coap_res_ptr->options_list_ptr->observe_ptr = &(battery_obs_number);
        coap_res_ptr->options_list_ptr->observe_len = 1;
        battery_obs_number++;
    }
    //if (m_logger != NULL) m_logger->log("Updating Observation (battery)...done");
}

/* Only GET method allowed */
uint8_t battery_cb(sn_coap_hdr_s *received_coap_ptr, sn_nsdl_addr_s *address, sn_proto_info_s *proto) {
    return nsp_get("battery",battery,received_coap_ptr,address,proto,&update_battery_observation);
}