// addldata resource implementation

#include "mbed.h"
#include "nsdl_support.h"
#include "addldata.h"
#include "NSPio.h"

extern Logger *logger;

NSPio *addldata = NULL;

// observation support
static uint8_t addldata_obs_number = 0;
static uint8_t *addldata_obs_token_ptr = NULL;
static uint8_t addldata_obs_token_len = 0;

// send our addldata observation
void send_addldata_observation() {
    if (addldata_obs_token_ptr != NULL && addldata_obs_number != 0) {
        //if (m_logger != NULL) m_logger->log("Sending Observation (addldata): %s",addldata->resource()->getValuePointer());
        sn_nsdl_send_observation_notification(addldata_obs_token_ptr,addldata_obs_token_len,(uint8_t*)addldata->resource()->getValuePointer(),strlen(addldata->resource()->getValuePointer()),&addldata_obs_number,sizeof(addldata_obs_number),COAP_MSG_TYPE_NON_CONFIRMABLE, 0);
    }
}

// init addldata
void init_addldata(Resource *resource) {
    if (addldata == NULL && resource != NULL) addldata = new NSPio(m_logger,resource,&send_addldata_observation);
}

// update our addldata observation
void update_addldata_observation(sn_coap_hdr_s *received_coap_ptr,sn_coap_hdr_s *coap_res_ptr) {
    //if (m_logger != NULL) m_logger->log("Updating Observation (addldata)...starting");
    if (received_coap_ptr->token_ptr != NULL) {
        if (addldata_obs_token_ptr != NULL) free(addldata_obs_token_ptr);
        addldata_obs_token_ptr = (uint8_t *)malloc(received_coap_ptr->token_len);
        if(addldata_obs_token_ptr != NULL) {
            memcpy(addldata_obs_token_ptr, received_coap_ptr->token_ptr, received_coap_ptr->token_len);
            addldata_obs_token_len = received_coap_ptr->token_len;
        }
    }
    if (received_coap_ptr->options_list_ptr->observe != NULL) {
        coap_res_ptr->options_list_ptr = (sn_coap_options_list_s*)malloc(sizeof(sn_coap_options_list_s));
        memset(coap_res_ptr->options_list_ptr, 0, sizeof(sn_coap_options_list_s));
        coap_res_ptr->options_list_ptr->observe_ptr = &(addldata_obs_number);
        coap_res_ptr->options_list_ptr->observe_len = 1;
        addldata_obs_number++;
    }
    //if (m_logger != NULL) m_logger->log("Updating Observation (addldata)...done");
}

/* Only GET and PUT method allowed */
uint8_t addldata_cb(sn_coap_hdr_s *received_coap_ptr, sn_nsdl_addr_s *address, sn_proto_info_s * proto) {
    return nsp_getput("addldata",addldata,received_coap_ptr,address,proto,&update_addldata_observation);
}