/* Copyright C2013 Doug Anson, MIT License
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy of this software
 * and associated documentation files the "Software", to deal in the Software without restriction,
 * including without limitation the rights to use, copy, modify, merge, publish, distribute,
 * sublicense, and/or sell copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in all copies or
 * substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING
 * BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM,
 * DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE. 
 */
 
#ifndef _DEFINITIONS_H_
#define _DEFINITIONS_H_

// platform
#include "mbed.h"

// Platform Switch
//#define   _ENDPOINT_UBLOX_PLATFORM      true                // uncomment for the U-Blox MBED platform
//#define   _ENDPOINT_FREESCALE_PLATFORM  true                // uncomment for the Freescale Freedom MBED platform
#define   _ENDPOINT_NXP_PLATFORM        true                // uncomment for the NXP MBED platform

// Network Usage (default is Ethernet)
//#define CELLULAR_NETWORK                true                        // true - use cellular network, false - use ethernet (cannot co-exist together)

// Multitech Temp Probe customization
#define MULTITECH_TEMP_PROBE            true                // true - on, undef - off

// what kind of personality we are...
#define LIGHT_PERSONALITY               true                // the endpoint will be a (set of) lights
//#define COPCAR_PERSONALITY              true                // the endpoint will emulate a cop car

// special behavior for APM CopCar - steady state on/off for blinking
//#define APM_COPCAR_ENABLE               true                      // true - enabled, (undef) - disabled

// APM Demo Light Configuration
#define APM_LIGHT_ENABLE            false                            // true - enable APM Demo light, undef - disable

// External LED Light Configuration
#define EXT_LED_ENABLE              true                            // true - enable external LED endpoint light, false - disable

// include common definitions
#include "CommonDefinitions.h"

// NSP specific definitions
#include "NSPDefinitions.h"

// Philips Light Config
#define PL_ENABLE                       false               // true - enable for endpoint light, false - disable
#define PL_LIGHT_ID                     PL_LIGHT_ID_BILL    // Default light for Philips Light

// Endpoint GPS Coordinates
//#define ENDPOINT_LOCATION               "Las Vegas Country Club"// Where this light/endpoint lives
//#define ENDPOINT_GPS_COORDS             "36.131258,-115.144414" // golf course 36.131258,-115.144414 
#define ENDPOINT_LOCATION               "Bilbao Spain Utilities"            // Where this light/endpoint lives
#define ENDPOINT_GPS_COORDS             "43.263383,-2.923628"     // Bilbao spain  

// DEBUG Hush Logging
//#define HUSH_LOG                      true          // false - logging output, true - no logging

// DEBUG Hush LED usage
//#define HUSH_LEDS                     true          // false - enable LEDs, true - disable LEDs

// DEBUG Memory Debug Enable/Disable
//#define ENABLE_MEMORY_DEBUG           true          // false - disable, true - enable (for all error_handler->log() operations)
//#define MEMORY_LOGGING                true          // false - disable, true - enable (for error_handler->log_memory() operations only)

// KEIL our MAC address
//#define MAC_ADDRESS                   0x00,0x1e,0xAB,0xE3,0x4F,0x55

#endif // _DEFINITIONS_H