/* Copyright C2013 Doug Anson, MIT License
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy of this software
 * and associated documentation files the "Software", to deal in the Software without restriction,
 * including without limitation the rights to use, copy, modify, merge, publish, distribute,
 * sublicense, and/or sell copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in all copies or
 * substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING
 * BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM,
 * DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 */
 
#ifndef _DEFINITIONS_H_
#define _DEFINITIONS_H_

// platform
#include "mbed.h"

// Platform Switch
#define   _ENDPOINT_UBLOX_PLATFORM      true                      // uncomment for the U-Blox MBED platform
//#define   _ENDPOINT_FREESCALE_PLATFORM  true                    // uncomment for the Freescale Freedom MBED platform
//#define   _ENDPOINT_NXP_PLATFORM        true                    // uncomment for the NXP MBED platform

// Network Usage (default is Ethernet)
#define CELLULAR_NETWORK                true                      // true - use cellular network, false - use ethernet (cannot co-exist together)
//#define CELLULAR_DEBUG                  true                      // true - debug enabled, undef - no

// what kind of personality we are...
#define LIGHT_PERSONALITY               true                      // the endpoint will be a (set of) lights
//#define COPCAR_PERSONALITY              true                      // the endpoint will emulate a cop car

// include common definitions
#include "CommonDefinitions.h"

// Turn all these on for cellular 
#define EH_USE_MUTEXES              true                            // true - yes, undef - no
#define NETWORK_MUTEX               true                            // true - yes, undef - no
#define ENABLE_THREADS              true                            // true - yes, undef - no

// MQTT specific support
#include "MQTTDefinitions.h"

// OVERRIDES
#undef GW_IPADDRESS
#undef IOC_HOST_NAME
#undef MQTT_HOSTNAME
#define GW_IPADDRESS                "192.168.1.220"                // Gateway Broker
#define IOC_HOST_NAME               "193.60.130.112"               // IOC Web - iocweb.bcu.ac.uk
#define MQTT_HOSTNAME               "193.60.130.110"               // IOC MQTT Broker Host - iocana.bcu.ac.uk

// Philips Light Config
#define PL_ENABLE                   false                         // true - enable for endpoint light, false - disable
#define PL_LIGHT_ID                 PL_LIGHT_ID_BILL              // Default light for Philips Light

// External LED Light Configuration
#define EXT_LED_ENABLE              true                          // true - enable external LED endpoint light, false - disable

// Endpoint GPS Coordinates/Location
#define ENDPOINT_LOCATION           "Las Vegas Police Dept"       // Where this light/endpoint lives
#define ENDPOINT_GPS_COORDS         "-115.147683 36.131735"       // Joe Brown Drive 

// Reset our config values if needed
#ifdef _ENDPOINT_UBLOX_PLATFORM
    #define UBLOX_USE_3G            true                          // use 3G or ethernet
    #define UBLOX_MODEM             UbloxUSBCDMAModem             // CDMA modem
    #define UBLOX_CDMA_DELAY_MS     1000                          // connect delay in MS
    #define UBLOX_GPS_FREQ          100000                        // GPS freq in ns
    #define UBLOX_GPS_POLL_MS       5000                          // poll the GPS every 5 seconds
#endif

// MBED doesnt have a good notion of time - so we code it here
#define ENDPOINT_STARTTIME          "\"STARTDATETIME\":\"2014-03-09T22:03:06-07:00\","
#define ENDPOINT_STOPTIME           "\"ENDDATETIME\":\"2015-03-10T03:35:55-07:00\","
#define ENDPOINT_TIMEZONE           "\"TIMEZONEOFFSET\":\"-07:00\""

// DEBUG Memory Debug Enable/Disable
// #define ENABLE_MEMORY_DEBUG         true             // false - disable, true - enable

// DEBUG Hush Logging
//#define HUSH_LOG                     true             // false - logging output, true - no logging

// DEBUG Hush LED usage
//#define HUSH_LEDS                     true             // false - enable LEDs, true - disable LEDs

// KEIL: our MAC address
//#define MAC_ADDRESS                   0xa0,0x12,0xAB,0xE3,0x4F,0x56

#endif // _DEFINITIONS_H