/* Copyright C2013 Doug Anson, MIT License
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy of this software
 * and associated documentation files the "Software", to deal in the Software without restriction,
 * including without limitation the rights to use, copy, modify, merge, publish, distribute,
 * sublicense, and/or sell copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in all copies or
 * substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING
 * BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM,
 * DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 */
 
#ifndef _DEFINITIONS_H_
#define _DEFINITIONS_H_

// platform
#include "mbed.h"

// Platform Switch
#define   _ENDPOINT_UBLOX_PLATFORM      true                      // uncomment for the U-Blox MBED platform
//#define   _ENDPOINT_FREESCALE_PLATFORM  true                    // uncomment for the Freescale Freedom MBED platform
//#define   _ENDPOINT_NXP_PLATFORM        true                    // uncomment for the NXP MBED platform

// Network Usage (default is Ethernet)
#define CELLULAR_NETWORK                true                      // true - use cellular network, false - use ethernet (cannot co-exist together)
//#define CELLULAR_DEBUG                  true                      // true - debug enabled, undef - no

// what kind of personality we are...
//#define LIGHT_PERSONALITY               true                      // the endpoint will be a (set of) lights
#define COPCAR_PERSONALITY              true                      // the endpoint will emulate a cop car

// special behavior for APM CopCar - steady state on/off for blinking
#define APM_COPCAR_ENABLE               true                      // true - enabled, (undef) - disabled

// APM Demo Light Configuration
#define APM_LIGHT_ENABLE            false                            // true - enable APM Demo light, undef - disable

// External LED Light Configuration
#define EXT_LED_ENABLE              true                            // true - enable external LED endpoint light, false - disable

// include common definitions
#include "CommonDefinitions.h"

// Turn all these on for cellular 
#define EH_USE_MUTEXES              true                          // true - yes, undef - no
#define NETWORK_MUTEX               true                          // true - yes, undef - no
#define ENABLE_THREADS              true                          // true - yes, undef - no

// MQTT specific support
#include "MQTTDefinitions.h"

// OVERRIDES
#undef GW_IPADDRESS
#undef GW_PORT
#undef IOC_HOST_NAME
#undef MQTT_HOSTNAME
//#define GW_IPADDRESS                "192.168.1.220"               // Gateway Broker IP
//#define GW_PORT                     "8888"                        // Gateway Broker port (def: 8888)

#define GW_IPADDRESS                "72.182.18.233"               // Gateway Broker IP (external)
#define GW_PORT                     "26278"                       // Gateway Broker port (external)

#define IOC_HOST_NAME               "193.60.130.112"              // IOC Web - iocweb.bcu.ac.uk
#define MQTT_HOSTNAME               "193.60.130.110"              // IOC MQTT Broker Host - iocana.bcu.ac.uk

// Philips Light Config
#define PL_ENABLE                   false                         // true - enable for endpoint light, false - disable
#define PL_LIGHT_ID                 PL_LIGHT_ID_BILL              // Default light for Philips Light

// Reset our config values if needed
#ifdef _ENDPOINT_UBLOX_PLATFORM
    #define UBLOX_GPS_FREQ          100000                        // GPS freq in ns
    #define UBLOX_GPS_POLL_MS       5000                          // poll the GPS every 5 seconds
#endif

// Endpoint GPS Coordinates/Location
//#define ENDPOINT_LOCATION           "Las Vegas Police Dept"       // Copcar location
//#define ENDPOINT_GPS_COORDS         "-115.147683 36.131735"       // Las Vegas
#define ENDPOINT_LOCATION           "ISSUU Dept - Bilbao Spain"     // Copcar location
#define ENDPOINT_GPS_COORDS         "-2.924335 43.262977"           // Bilbao Spain 

// MBED doesnt have a good notion of time - so we code it here
#define ENDPOINT_STARTTIME          "\"STARTDATETIME\":\"2014-07-25T22:03:06-07:00\","
#define ENDPOINT_STOPTIME           "\"ENDDATETIME\":\"2015-08-10T03:35:55-07:00\","
#define ENDPOINT_TIMEZONE           "\"TIMEZONEOFFSET\":\"+01:00\""

// DEBUG Memory Debug Enable/Disable
// #define ENABLE_MEMORY_DEBUG         true             // false - disable, true - enable

// DEBUG Hush Logging
//#define HUSH_LOG                     true             // false - logging output, true - no logging

// DEBUG Hush LED usage
//#define HUSH_LEDS                     true             // false - enable LEDs, true - disable LEDs

// KEIL: our MAC address
//#define MAC_ADDRESS                   0xa0,0x12,0xAB,0xE3,0x4F,0x56

#endif // _DEFINITIONS_H