/**
 * @file    network_stubs.cpp
 * @brief   mbed Endpoint network stubs implementation (6LowPAN)
 * @author  Doug Anson
 * @version 1.0
 * @see     
 *
 * Copyright (c) 2014
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
 
#include "network_stubs.h"

extern "C" {

// Tasklet ID..    
int main_tasklet_id = -1;

// randomize the MAC address
void randomize_mac_address()
{
    // just extern it for now
    extern uint8_t app_MAC_address[NODE_MAC_ADDRESS_LENGTH];
    extern uint8_t endpoint_name[NODE_NAME_LENGTH];
    
    // seed (weak)
    srand(time(NULL));
    
    // rand() with some added variance from endpoint name
    for(int i=0;i<NODE_MAC_ADDRESS_LENGTH;++i) app_MAC_address[i] = (rand()*endpoint_name[i])%256;
    
    // display
    std::printf("MAC Address: 0x%.2x::0x%.2x::0x%.2x::0x%.2x::0x%.2x::0x%.2x::0x%.2x::0x%.2x\r\n",
                app_MAC_address[0],app_MAC_address[1],app_MAC_address[2],app_MAC_address[3],
                app_MAC_address[4],app_MAC_address[5],app_MAC_address[6],app_MAC_address[7]);
}

// Nanostack_6LowPAN tasklet main handler function...
extern "C" void tasklet_main(void);

// plumb out the network
void net_stubs_pre_plumb_network(bool canActAsRouterNode) 
{
    // randomize the MAC address
    randomize_mac_address();
    
    // call init_network()
    init_network(canActAsRouterNode);
}

// called after the endpoint is configured...
void net_stubs_post_plumb_network(void) 
{
    // not used - mesh network is already setup...
    ;
}

// create a suitable main event loop for this specific network
void net_stubs_create_main_loop(void)
{
    // tasklet creation...
    DBG("net_stubs_begin_main_loop: creating tasklet for main loop...\r\n");
    main_tasklet_id = arm_ns_tasklet_create(&tasklet_main);
    if(main_tasklet_id < 0) {
        //Tasklet cerate fail
        DBG("net_stubs_begin_main_loop: Tasklet creation failed...\r\n");
        return;
    }   
}

// register the endpoint
void net_stubs_register_endpoint(void)
{
    // call NSP_registration()
    NSP_registration();
}

// begin the main loop for processing network events
void net_stubs_begin_main_loop(void) 
{
    // start event dispatching
    DBG("net_stubs_begin_main_loop: Beginning event dispatch...\r\n");
    event_dispatch();
    return;
}

}