#include "arm_hal_interrupt.h"
#include "sleep_api.h"

/** Global Variables which indicate when interrupt are disabled */
uint8_t sys_irq_disable_counter = 0;
uint8_t sys_wait_signal = 0;

void arm_enter_critical(void)
{
     if (sys_irq_disable_counter++ == 0) {
         __disable_irq();
     }
}

void arm_exit_critical(void)
{
     if (--sys_irq_disable_counter == 0) {
         __enable_irq();
     }
}

void hal_event_os_wait(void)
{
     arm_enter_critical();
     sys_wait_signal = 1;
     arm_exit_critical();
     while (sys_wait_signal) {
         /*CPU in idle*/
         sleep();             // ENABLE?
     }
}

void hal_event_os_signal(void)
{
     sys_wait_signal = 0;
}

uint32_t hal_event_os_sleep(uint32_t sleep_time_ms)
{
    // needs to be implemented
    return 1;
}
