// NSDL library support functions

#include "configuration.h"
#include "mbedConnectorInterface.h"
#include "debug.h"
#include "nsdl_support.h"
#include "socket_api.h"

// we have to redefine DBG as its used differently here...
#ifdef DBG
    #undef DBG
#endif
#define DBG  printf

static ns_address_t app_dest;
char null_ep_name[] = "";
char null_ep_domain[] = "";
uint8_t null_ep_type[] = "";
uint8_t null_lifetime_ptr[] = "";
bool nsdl_reg_update_needed = false;
bool endpoint_registered = false;

extern int8_t coap_udp_socket;
        
void *nsdl_alloc(uint16_t size)
{
    void *buf = malloc(size);
    return buf;
}

void nsdl_free(void* ptr_to_free)
{
    free(ptr_to_free);
}

/*
 * Create a static resoure
 * Only get is allowed
 */
void nsdl_create_static_resource(sn_nsdl_resource_info_s *resource_structure, uint16_t pt_len, uint8_t *pt, uint16_t rpp_len, uint8_t *rpp_ptr, uint8_t *rsc, uint16_t rsc_len)
{
    resource_structure->access = SN_GRS_GET_ALLOWED;
    resource_structure->mode = SN_GRS_STATIC;
    resource_structure->pathlen = pt_len;
    resource_structure->path = pt;
    resource_structure->resource_parameters_ptr->resource_type_len = rpp_len;
    resource_structure->resource_parameters_ptr->resource_type_ptr = rpp_ptr;
    resource_structure->resource = rsc;
    resource_structure->resourcelen = rsc_len;
    sn_nsdl_create_resource(resource_structure);
}

void nsdl_create_dynamic_resource(sn_nsdl_resource_info_s *resource_structure, uint16_t pt_len, uint8_t *pt, uint16_t rpp_len, uint8_t *rpp_ptr, uint8_t is_observable, sn_grs_dyn_res_callback_t callback_ptr, int access_right)
{
    resource_structure->access = (sn_grs_resource_acl_e)access_right;
    resource_structure->resource = 0;
    resource_structure->resourcelen = 0;
    resource_structure->sn_grs_dyn_res_callback = callback_ptr;
    resource_structure->mode = SN_GRS_DYNAMIC;
    resource_structure->pathlen = pt_len;
    resource_structure->path = pt;
    resource_structure->resource_parameters_ptr->resource_type_len = rpp_len;
    resource_structure->resource_parameters_ptr->resource_type_ptr = rpp_ptr;
    resource_structure->resource_parameters_ptr->observable = is_observable;
    sn_nsdl_create_resource(resource_structure);
}

sn_nsdl_ep_parameters_s* nsdl_init_register_endpoint(sn_nsdl_ep_parameters_s *endpoint_structure, uint8_t *domain, uint8_t* name, uint8_t* typename_ptr, uint8_t *lifetime_ptr)
{
    if (endpoint_structure == NULL)
    {   
        endpoint_structure = (sn_nsdl_ep_parameters_s*)nsdl_alloc(sizeof(sn_nsdl_ep_parameters_s));
    }
    if (endpoint_structure != NULL)
    {
        memset(endpoint_structure, 0, sizeof(sn_nsdl_ep_parameters_s));
        endpoint_structure->endpoint_name_ptr = name;
        endpoint_structure->endpoint_name_len = strlen((char*)name);
        endpoint_structure->domain_name_ptr = domain;
        endpoint_structure->domain_name_len = strlen((char*)domain);
        endpoint_structure->type_ptr = typename_ptr;
        endpoint_structure->type_len =  strlen((char*)typename_ptr);
        endpoint_structure->lifetime_ptr = lifetime_ptr;
        endpoint_structure->lifetime_len =  strlen((char*)lifetime_ptr);         
    }
    return endpoint_structure;
}

void nsdl_clean_register_endpoint(sn_nsdl_ep_parameters_s **endpoint_structure)
{
    if (*endpoint_structure)
    {
        nsdl_free(*endpoint_structure);
        *endpoint_structure = NULL;
    }
}

static uint8_t tx_cb(sn_nsdl_capab_e protocol, uint8_t *data_ptr, uint16_t datalen, sn_nsdl_addr_s *address_prt)
{
    DBG("TX callback!\n\rSending %d bytes...", datalen);
    //DBG("Payload:'");
    //for (int i=0; i < datalen; i++)
    //    DBG("%c", *(data_ptr + i));
    //DBG("' \r\n");

    int8_t socket_ret_value = 0;
    memcpy(app_dest.address, address_prt->addr_ptr, 16);
    app_dest.identifier = address_prt->port;
    app_dest.type = ADDRESS_IPV6;       

        socket_ret_value = socket_sendto(coap_udp_socket, &app_dest, data_ptr, datalen);
        if(socket_ret_value != 0)
            {   
                   DBG("Failed\r\n");                            
                    return 0;//failed
            }
            else
            {   
                                 DBG("Ok\r\n");
                    return 1; // success
            }
}

static uint8_t rx_cb(sn_coap_hdr_s *coap_packet_ptr, sn_nsdl_addr_s *address_ptr)
{
    DBG("RX callback!\r\n");
    DBG("msg_code: %d \r\n", coap_packet_ptr->msg_code);
    DBG("Payload length: %d bytes\r\n", coap_packet_ptr->payload_len);
    int i;
    DBG("Payload:'");
    for (i=0; i < coap_packet_ptr->payload_len; i++)
        DBG("%c", *(coap_packet_ptr->payload_ptr + i));
    DBG("' \r\n");
    if (coap_packet_ptr->options_list_ptr && coap_packet_ptr->options_list_ptr->location_path_ptr)
    {
        DBG("Location: /");
        int i;
        for (i=0; i < coap_packet_ptr->options_list_ptr->location_path_len; i++) DBG("%c", (char)(coap_packet_ptr->options_list_ptr->location_path_ptr[i]));
        DBG(" \r\n");
    }
    //sn_coap_packet_debug(coap_packet_ptr);
    return 0;
}


void NSP_registration( ) { 
        sn_nsdl_ep_parameters_s *endpoint_ptr = NULL;
 
        if (endpoint_registered){
            nsdl_reg_update();
        }
        else{
            endpoint_ptr = nsdl_init_register_endpoint(endpoint_ptr, (uint8_t *)domain_name, (uint8_t*)endpoint_name, ep_type, lifetime_ptr);
            if(sn_nsdl_register_endpoint(endpoint_ptr) != 0) {
                DBG("NSP registering failed\r\n");
                endpoint_registered = false;
            }
            else {
                DBG("NSP registering OK\r\n");
                endpoint_registered = true;
            }
            nsdl_clean_register_endpoint(&endpoint_ptr);
        }
}

bool nsdl_endpoint_is_registered(void) {
    return endpoint_registered;
}

void nsdl_init()
{
    //uint8_t nsp_addr[4];
    sn_nsdl_mem_s memory_cbs;

    /* Initialize libNsdl */
    memory_cbs.sn_nsdl_alloc = &nsdl_alloc;
    memory_cbs.sn_nsdl_free = &nsdl_free;
    if(sn_nsdl_init(&tx_cb, &rx_cb, &memory_cbs) == -1)
        DBG("libNsdl init failed\r\n");
    else
        DBG("libNsdl init done\r\n");
        /* Set nsp address for library */     
        set_NSP_address(NSP_address_bytes, NSP_COAP_UDP_PORT, SN_NSDL_ADDRESS_TYPE_IPV6);
}

void nsdl_reg_update()
{
    sn_nsdl_ep_parameters_s *endpoint_ptr = NULL;
    // reg update should be invoked with null parameters if nothing is changing
    endpoint_ptr = nsdl_init_register_endpoint(endpoint_ptr, (uint8_t *)null_ep_domain, (uint8_t*)null_ep_name, null_ep_type, null_lifetime_ptr);
    if(sn_nsdl_update_registration(endpoint_ptr) != 0) {
        DBG("NSP re-registering failed\r\n");
        endpoint_registered = false;
    }
    else {
        DBG("NSP re-registering OK\r\n");
        endpoint_registered = true;
    }
    
    nsdl_clean_register_endpoint(&endpoint_ptr);
}
    
void nsdl_reg_update_timeout()
{
    nsdl_reg_update_needed = true;
}

void nsdl_event_loop()
{

    sn_nsdl_addr_s received_packet_address;
    uint8_t received_address[4];

    memset(&received_packet_address, 0, sizeof(sn_nsdl_addr_s));
    received_packet_address.addr_ptr = received_address;

    while(1)
    {
        //pc.DBG("checking reg timeout\r\n");
        if (nsdl_reg_update_needed)
        {
            nsdl_reg_update_needed = false;
            
            if (nsdl_endpoint_is_registered()) 
                nsdl_reg_update();
            else
                NSP_registration();
            
            // wait just a bit...    
            //wait_ms(1000);
        }
    }
}

void nsdl_set_nsp_address(void) {
    // not used in 6LowPAN version of nsdl_support.cpp
    ;
}
