/* Copyright C2014 ARM, MIT License
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy of this software
 * and associated documentation files the "Software", to deal in the Software without restriction,
 * including without limitation the rights to use, copy, modify, merge, publish, distribute,
 * sublicense, and/or sell copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in all copies or
 * substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING
 * BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM,
 * DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 */
 
 #ifndef _DEFINITIONS_H_
 #define _DEFINITIONS_H_
 
 // mbed 
 #include "mbed.h"
 
 // Our App version
 #define APP_VERSION               "1.0.0"
 
 // Enable/Disable verbose debugging
 #define ENABLE_DEBUG_LOGGING      false         // true - enabled, false - disabled (default)
     
 // maximum memory buffer chunk
 #define MAX_BUFFER_LENGTH         2048
  
 // small buffer chunk
 #define MAX_SMALL_BUFFER_LENGTH   256
 
 // Blink Time
 #define BLINK_TIME                250
 
 // Max number of retries
 #define MAX_TRIES                 4
 
 // Wait Time for iterations (ms)
 #define WAIT_TIME_MS              2500
 
 // What platform we are compiling on
 #define _K64F_PLATFORM            true
 
 // K64F needs to launch the task in a thread with a large stack size...
 #if _K64F_PLATFORM
    #define STACK_SIZE             40000
 #endif
  
 #endif // _DEFINITIONS_H_