/* Copyright C2014 ARM, MIT License
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy of this software
 * and associated documentation files the "Software", to deal in the Software without restriction,
 * including without limitation the rights to use, copy, modify, merge, publish, distribute,
 * sublicense, and/or sell copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in all copies or
 * substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING
 * BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM,
 * DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 */
 
 #ifndef _DEFINITIONS_H_
 #define _DEFINITIONS_H_
 
 // ----------------- WORKSHOP TUNABLES -----------------  
  
 // SUPPORT PERSON #1 (this will be dispatched as a Case if the first RFID tag is swiped)
 #define FIRST_SUPPORT_PERSON_RFID         1234567
 #define FIRST_SUPPORT_PERSON_NAME         "James T. Kirk"
 #define FIRST_SUPPORT_PERSON_DESCRIPTION  "Federation Technician #NCC-1701"
 #define FIRST_SUPPORT_PERSON_STATUS       "On site/servicing"
 #define FIRST_SUPPORT_PERSON_LATITUDE     "37.404120"
 #define FIRST_SUPPORT_PERSON_LONGITUDE    "-121.973195"
 
 // SUPPORT PERSON #2 (this will be dispatched as a Case if the second RFID tag is swiped)
 #define SECOND_SUPPORT_PERSON_RFID        1234567
 #define SECOND_SUPPORT_PERSON_NAME        "Harry Potter"
 #define SECOND_SUPPORT_PERSON_DESCRIPTION "Hogwarts Technician #WIZ-1234"
 #define SECOND_SUPPORT_PERSON_STATUS      "On site/servicing"
 #define SECOND_SUPPORT_PERSON_LATITUDE    "37.404120"
 #define SECOND_SUPPORT_PERSON_LONGITUDE   "-121.973195"
 
 // SUPPORT PERSON #3 (this will be dispatched as a Case if the third RFID tag is swiped)
 #define THIRD_SUPPORT_PERSON_RFID         1234567
 #define THIRD_SUPPORT_PERSON_NAME         "Kramer"
 #define THIRD_SUPPORT_PERSON_DESCRIPTION  "UNKNOWN Technician #-1"
 #define THIRD_SUPPORT_PERSON_STATUS       "Off site/action unsure"
 #define THIRD_SUPPORT_PERSON_LATITUDE     "37.404120"
 #define THIRD_SUPPORT_PERSON_LONGITUDE    "-121.973195"
 
 // ----------------- WORKSHOP TUNABLES ----------------- 
 
 // mbed 
 #include "mbed.h"
 
 // Our App version
 #define APP_VERSION                "1.0.0"
  
 // DF2014 CaseGenerator Relay for mbed - ties into the Salesforce APEX host for case generation
 #define DF_CASE_GEN_URL            "https://df2014-arm-developer-edition.na15.force.com/services/apexrest/CaseService"
 
 // Enable/Disable RFID ID12 usage
 #define ID12_ENABLE                true    // true - enable, false - disable
 
 // Enable/Disable verbose debugging
 #define ENABLE_DEBUG_LOGGING       false         // true - enabled, false - disabled (default)
     
 // maximum memory buffer chunk
 #define MAX_BUFFER_LENGTH          2048
  
 // small buffer chunk
 #define MAX_SMALL_BUFFER_LENGTH    256

 // What platform we are compiling on
 #define _K64F_PLATFORM             true
 
 // K64F needs to launch the task in a thread with a large stack size...
 #define STACK_SIZE                 40000
   
 // Wait Time for iterations (ms)
 #define WAIT_TIME_MS               500
 
 // Blink Time
 #define BLINK_TIME                 250
 
 // Memory tunables for SupportPersonnelDB
 #define DB_MAX_NAME_LENGTH         64
 #define DB_MAX_DESCRIPTION_LENGTH  128
 #define DB_MAX_STATUS_LENGTH       128
 #define DB_MAX_LATLONG_LENGTH      32
 #define DB_MAX_NUM_SUPPORT_PERSONS 3
 
 // convenience definitions for SupportPersonnelDB... 3 RFID tags/workshop station  
 #define FIRST_SUPPORT_PERSON       0
 #define SECOND_SUPPORT_PERSON      1
 #define THIRD_SUPPORT_PERSON       2
 
 // PINS for RFID Reader Shield - ID12 RFID sensor + TMP36 temperature sensor
 #define RFID_TX_PIN                D1
 #define RFID_RX_PIN                D0
 #define TEMP_PIN                   A3
 
 #endif // _DEFINITIONS_H_