// Light resource implementation

#include "mbed.h"
#include "nsdl_support.h"
#include "ChainableLED.h"
#include "LED_array.h"

#define LED_ARRAY_RES_ID    "11100/0/5900"
#define LED_ARRAY_RES_RT    "urn:X-mbed:LEDarray"

extern Serial pc;
char led_value[] = {"0000000"}; //RRGGBBII

#define LED_COUNT 1

ChainableLED led_chain(P0_0, P0_1, LED_COUNT);

uint8_t LED_array_max_age = 0; 
uint8_t LED_array_content_type = 0;

void set_led_array(char *color_string)
{
    static uint8_t red, green, blue, index;
    int color_int;

    sscanf(color_string, "%X", &color_int);
    
    index = color_int & 255;
    blue = color_int >> 8 & 255;
    green = color_int >> 16 & 255;
    red = color_int >> 24 & 255;
        
    if(index > 0 and index <= LED_COUNT)
    {
        led_chain.setColorRGB(index-1, red, green, blue);    
    }
    else if(index == 0)
    {
        for(int i = 0; i < LED_COUNT; i++)
        {
            led_chain.setColorRGB(i, red, green, blue);    
        }
    }    
}


/* Only GET and PUT method allowed */
static uint8_t LED_array_resource_cb(sn_coap_hdr_s *received_coap_ptr, sn_nsdl_addr_s *address, sn_proto_info_s * proto)
{
    sn_coap_hdr_s *coap_res_ptr = 0;

    //pc.printf("LED array callback\r\n");

    if(received_coap_ptr->msg_code == COAP_MSG_CODE_REQUEST_GET)
    {
        coap_res_ptr = sn_coap_build_response(received_coap_ptr, COAP_MSG_CODE_RESPONSE_CONTENT);

        coap_res_ptr->payload_len = strlen(led_value);
        coap_res_ptr->payload_ptr = (uint8_t*)led_value;
        
        coap_res_ptr->content_type_ptr = &LED_array_content_type;
        coap_res_ptr->content_type_len = sizeof(LED_array_content_type);
        
        coap_res_ptr->options_list_ptr = (sn_coap_options_list_s*)nsdl_alloc(sizeof(sn_coap_options_list_s));
        if(!coap_res_ptr->options_list_ptr)
            {
            pc.printf("cant alloc option list for max-age\r\n");
            coap_res_ptr->options_list_ptr = NULL; //FIXME report error and recover
            }
        memset(coap_res_ptr->options_list_ptr, 0, sizeof(sn_coap_options_list_s));
        coap_res_ptr->options_list_ptr->max_age_ptr = &LED_array_max_age;
        coap_res_ptr->options_list_ptr->max_age_len = sizeof(LED_array_max_age);

        sn_nsdl_send_coap_message(address, coap_res_ptr);
        nsdl_free(coap_res_ptr->options_list_ptr);
        coap_res_ptr->options_list_ptr = NULL;
        coap_res_ptr->content_type_ptr = NULL;// parser_release below tries to free this memory

    }
    else if(received_coap_ptr->msg_code == COAP_MSG_CODE_REQUEST_PUT)
    {
        //pc.printf("PUT: %d bytes\r\n", received_coap_ptr->payload_len);
        if(received_coap_ptr->payload_len == 8)
        {
            memcpy(led_value, (char *)received_coap_ptr->payload_ptr, received_coap_ptr->payload_len);

            led_value[received_coap_ptr->payload_len] = '\0';
            pc.printf("PUT: %s\r\n",led_value);

            //call LED array update function here
            set_led_array(led_value);

            coap_res_ptr = sn_coap_build_response(received_coap_ptr, COAP_MSG_CODE_RESPONSE_CHANGED);
            sn_nsdl_send_coap_message(address, coap_res_ptr);
        }
    }

    sn_coap_parser_release_allocated_coap_msg_mem(coap_res_ptr);
    return 0;
}

int create_LED_array_resource(sn_nsdl_resource_info_s *resource_ptr)
{
    nsdl_create_dynamic_resource(resource_ptr, sizeof(LED_ARRAY_RES_ID)-1, (uint8_t*)LED_ARRAY_RES_ID, sizeof(LED_ARRAY_RES_RT)-1, (uint8_t*)LED_ARRAY_RES_RT, 0, &LED_array_resource_cb, (SN_GRS_GET_ALLOWED | SN_GRS_PUT_ALLOWED));
    set_led_array("FF000000");
    wait(0.5);
    set_led_array("00FF0000");
    wait(0.5);
    set_led_array("0000FF00");
    wait(0.5);
    set_led_array("00000000");

            
    return 0;
}