// GPS resource implementation

#include "mbed.h"
#include "nsdl_support.h"
#include "gps.h"

#define GPS_RES_ID    "gps/loc"

extern Serial pc;
static uint8_t res_gps_val[] = {"34.156541, -118.422498"};

/* Only GET method allowed */
static uint8_t gps_resource_cb(sn_coap_hdr_s *received_coap_ptr, sn_nsdl_addr_s *address, sn_proto_info_s * proto)
{
    sn_coap_hdr_s *coap_res_ptr = 0;
    static float led_dimm = 0;
    int led_state = 0;
    char led_dimm_temp[4];

    pc.printf("gps callback\r\n");

    coap_res_ptr = sn_coap_build_response(received_coap_ptr, COAP_MSG_CODE_RESPONSE_CONTENT);

    led_state = led_dimm * 100;
    sprintf(led_dimm_temp, "%d", led_state);

    coap_res_ptr->payload_len = sizeof(res_gps_val)-1;
    coap_res_ptr->payload_ptr = (uint8_t*)res_gps_val;

    sn_nsdl_send_coap_message(address, coap_res_ptr);

    sn_coap_parser_release_allocated_coap_msg_mem(coap_res_ptr);
    
    return 0;
}

int create_gps_resource(sn_nsdl_resource_info_s *resource_ptr)
{
    nsdl_create_dynamic_resource(resource_ptr, sizeof(GPS_RES_ID)-1, (uint8_t*)GPS_RES_ID, 0, 0, 1, &gps_resource_cb, SN_GRS_GET_ALLOWED);
    return 0;
}