// Magnetometer resource implementation

#include "mbed.h"
#include "nsdl_support.h"
#include "Wi-Go_eCompass_Lib_V3.h"

#define MAGNET_X_RES_ID    "3314/0/0"
#define MAGNET_Y_RES_ID    "3314/0/1"
#define MAGNET_Z_RES_ID    "3314/0/2"
#define COMPASS_RES_ID    "3314/0/3"

extern Serial pc;
extern axis6_t axis6;
char mx[7];
char my[7];
char mz[7];
char compass[7];

/* Only GET method allowed */

static uint8_t magnet_x_resource_cb(sn_coap_hdr_s *received_coap_ptr, sn_nsdl_addr_s *address, sn_proto_info_s * proto)
{
    sn_coap_hdr_s *coap_res_ptr = 0;
    sprintf(mx,"%3.1f", axis6.fUTmx);
    pc.printf("magnet x callback\r\n");
    pc.printf("magnet x %s\r\n", mx);

    if(received_coap_ptr->msg_code == COAP_MSG_CODE_REQUEST_GET)
    {
        coap_res_ptr = sn_coap_build_response(received_coap_ptr, COAP_MSG_CODE_RESPONSE_CONTENT);

        coap_res_ptr->payload_len = strlen(mx);
        coap_res_ptr->payload_ptr = (uint8_t*)mx;
        sn_nsdl_send_coap_message(address, coap_res_ptr);
    }

    sn_coap_parser_release_allocated_coap_msg_mem(coap_res_ptr);
    
    return 0;
}

static uint8_t magnet_y_resource_cb(sn_coap_hdr_s *received_coap_ptr, sn_nsdl_addr_s *address, sn_proto_info_s * proto)
{
    sn_coap_hdr_s *coap_res_ptr = 0;
    sprintf(my,"%3.1f", axis6.fUTmy);
    pc.printf("magnet y callback\r\n");
    pc.printf("magnet y %s\r\n", my);

    if(received_coap_ptr->msg_code == COAP_MSG_CODE_REQUEST_GET)
    {
        coap_res_ptr = sn_coap_build_response(received_coap_ptr, COAP_MSG_CODE_RESPONSE_CONTENT);

        coap_res_ptr->payload_len = strlen(my);
        coap_res_ptr->payload_ptr = (uint8_t*)my;
        sn_nsdl_send_coap_message(address, coap_res_ptr);
    }

    sn_coap_parser_release_allocated_coap_msg_mem(coap_res_ptr);
    
    return 0;
}

static uint8_t magnet_z_resource_cb(sn_coap_hdr_s *received_coap_ptr, sn_nsdl_addr_s *address, sn_proto_info_s * proto)
{
    sn_coap_hdr_s *coap_res_ptr = 0;
    sprintf(mz,"%3.1f", axis6.fUTmz);
    pc.printf("magnet z callback\r\n");
    pc.printf("magnet z %s\r\n", mz);

    if(received_coap_ptr->msg_code == COAP_MSG_CODE_REQUEST_GET)
    {
        coap_res_ptr = sn_coap_build_response(received_coap_ptr, COAP_MSG_CODE_RESPONSE_CONTENT);

        coap_res_ptr->payload_len = strlen(mz);
        coap_res_ptr->payload_ptr = (uint8_t*)mz;
        sn_nsdl_send_coap_message(address, coap_res_ptr);
    }

    sn_coap_parser_release_allocated_coap_msg_mem(coap_res_ptr);
    
    return 0;
}

static uint8_t compass_resource_cb(sn_coap_hdr_s *received_coap_ptr, sn_nsdl_addr_s *address, sn_proto_info_s * proto)
{
    sn_coap_hdr_s *coap_res_ptr = 0;
    sprintf(compass,"%d", axis6.compass);
    pc.printf("compass callback\r\n");
    pc.printf("compass %s\r\n", compass);

    if(received_coap_ptr->msg_code == COAP_MSG_CODE_REQUEST_GET)
    {
        coap_res_ptr = sn_coap_build_response(received_coap_ptr, COAP_MSG_CODE_RESPONSE_CONTENT);

        coap_res_ptr->payload_len = strlen(compass);
        coap_res_ptr->payload_ptr = (uint8_t*)compass;
        sn_nsdl_send_coap_message(address, coap_res_ptr);
    }

    sn_coap_parser_release_allocated_coap_msg_mem(coap_res_ptr);
    
    return 0;
}

int create_magnet_resource(sn_nsdl_resource_info_s *resource_ptr)
{
//    nsdl_create_dynamic_resource(resource_ptr, sizeof(MAGNET_X_RES_ID)-1, (uint8_t*)MAGNET_X_RES_ID, 0, 0, 0, &magnet_x_resource_cb, (SN_GRS_GET_ALLOWED));
//    nsdl_create_dynamic_resource(resource_ptr, sizeof(MAGNET_Y_RES_ID)-1, (uint8_t*)MAGNET_Y_RES_ID, 0, 0, 0, &magnet_y_resource_cb, (SN_GRS_GET_ALLOWED));
//    nsdl_create_dynamic_resource(resource_ptr, sizeof(MAGNET_Z_RES_ID)-1, (uint8_t*)MAGNET_Z_RES_ID, 0, 0, 0, &magnet_z_resource_cb, (SN_GRS_GET_ALLOWED));
    nsdl_create_dynamic_resource(resource_ptr, sizeof(COMPASS_RES_ID)-1, (uint8_t*)COMPASS_RES_ID, 0, 0, 0, &compass_resource_cb, (SN_GRS_GET_ALLOWED));
    return 0;
}