#ifndef DEMO_H
#define DEMO_H
#include "TCPSocketConnection.h"
#include "TCPSocketServer.h"

#ifdef    __cplusplus
extern "C" {
#endif

#define MAX_CGI_PARAMS 4
#define MAX_DYN_HTML_PARAMS 9
#define MAX_DYN_HTML_PARAM_SIZE 40
#define ROOT "/"


#define HTTP_RESP "HTTP/1.0 200 OK\n\n"

#define HTTP_CGI_ENABLED
#define HTTP_DYN_HTML_ENABLED
#define HTTP_PORT     80

#define MAX_REPLACE_CHAR 16


// Struct that indicates all the elements necessary to handle
typedef struct
{
    // name of parameter that will be analyzed
    // Currently not implemented to verify each
    // This would enable us to be flexible with parameter list
    //char [][]
    
    // Array of functions that will handle each parameter
    void (*cgiHandlerFunc[MAX_CGI_PARAMS])(char *);
        
} cgi_handler;


typedef struct
{
     char dynHtmlParamName[MAX_DYN_HTML_PARAMS][MAX_DYN_HTML_PARAM_SIZE];
     void (*dynHtmlFunc[40])(char *);  //PF was 20
} dyn_html_handler;

void serverMain(int port, char * ipage,  cgi_handler * handleList, dyn_html_handler * dhList);
void handleHTTPRequest(TCPSocketConnection *client);
void pageReplace(char * page, char * ind, char * val);
void getViewsNum(char * str);
void sendHTTPData(char * buf, long len, TCPSocketConnection *client);

int demo_wifi_main(void);
void testFunc(char * str);
void getBatteryVoltageStr(char * str);
void getLightVoltageStr(char * str);
void getAccelXYZ_Str(char * str);
void getTemperatureStr(char * str);
void getTSI_sliderStr(char * str);
void getCompassStr(char * str);
void getM3110Str(char * str);
void getAltitudeStr(char * str);

#ifdef    __cplusplus
}
#endif // __cplusplus
#endif // DEMO_H

