// slide selector resource implementation

#include "mbed.h"
#include "nsdl_support.h"
#include "TSISensor.h"

#define SLIDER_RES_ID    "3300/1/5700"

extern Serial pc;
char sliderPct[5];
extern TSISensor tsi;
int slider_position;

/* Only GET method allowed */
static uint8_t slider_resource_cb(sn_coap_hdr_s *received_coap_ptr, sn_nsdl_addr_s *address, sn_proto_info_s * proto)
{
    sn_coap_hdr_s *coap_res_ptr = 0;
    slider_position = tsi.readPercentage() * 100;
    sprintf(sliderPct,"%d", slider_position);
    pc.printf("slider callback\r\n");
    pc.printf("slider percent %s\r\n", sliderPct);

    if(received_coap_ptr->msg_code == COAP_MSG_CODE_REQUEST_GET)
    {
        coap_res_ptr = sn_coap_build_response(received_coap_ptr, COAP_MSG_CODE_RESPONSE_CONTENT);

        coap_res_ptr->payload_len = strlen(sliderPct);
        coap_res_ptr->payload_ptr = (uint8_t*)sliderPct;
        sn_nsdl_send_coap_message(address, coap_res_ptr);
    }

    sn_coap_parser_release_allocated_coap_msg_mem(coap_res_ptr);

    return 0;
}

int create_slider_resource(sn_nsdl_resource_info_s *resource_ptr)
{
    nsdl_create_dynamic_resource(resource_ptr, sizeof(SLIDER_RES_ID)-1, (uint8_t*)SLIDER_RES_ID, 0, 0, 0, &slider_resource_cb, (SN_GRS_GET_ALLOWED));
    return 0;
}