// battery resource implementation

#include "mbed.h"
#include "nsdl_support.h"

#define BATTERY_RES_ID    "3300/0/5700"

extern Serial pc;
char battPct[5];
extern unsigned short adc_sample3;

/* Only GET method allowed */
static uint8_t battery_resource_cb(sn_coap_hdr_s *received_coap_ptr, sn_nsdl_addr_s *address, sn_proto_info_s * proto)
{
    sn_coap_hdr_s *coap_res_ptr = 0;
    sprintf(battPct,"%d",adc_sample3);
    pc.printf("battery callback\r\n");
    pc.printf("battery percent %s\r\n", battPct);

    if(received_coap_ptr->msg_code == COAP_MSG_CODE_REQUEST_GET)
    {
        coap_res_ptr = sn_coap_build_response(received_coap_ptr, COAP_MSG_CODE_RESPONSE_CONTENT);

        coap_res_ptr->payload_len = strlen(battPct);
        coap_res_ptr->payload_ptr = (uint8_t*)battPct;
        sn_nsdl_send_coap_message(address, coap_res_ptr);
    }

    sn_coap_parser_release_allocated_coap_msg_mem(coap_res_ptr);

    return 0;
}

int create_battery_resource(sn_nsdl_resource_info_s *resource_ptr)
{
    nsdl_create_dynamic_resource(resource_ptr, sizeof(BATTERY_RES_ID)-1, (uint8_t*)BATTERY_RES_ID, 0, 0, 0, &battery_resource_cb, (SN_GRS_GET_ALLOWED));
    return 0;
}