// RGB LED resource implementation

#include "mbed.h"
#include "nsdl_support.h"
#include "defLED.h"
#include "rgbled.h"

#define RED_LED_RES_ID    "3311/0/5850/0"
#define GRN_LED_RES_ID    "3311/0/5850/1"
#define BLU_LED_RES_ID    "3311/0/5850/2"

extern Serial pc;
extern DigitalOut ledr;
extern DigitalOut ledg;
extern DigitalOut ledb;

static uint8_t red_led_state = '0';
static uint8_t grn_led_state = '0';
static uint8_t blu_led_state = '0';

/* Only GET and PUT method allowed */
static uint8_t red_led_resource_cb(sn_coap_hdr_s *received_coap_ptr, sn_nsdl_addr_s *address, sn_proto_info_s * proto)
{
    sn_coap_hdr_s *coap_res_ptr = 0;

    pc.printf("red_led callback\r\n");

    if(received_coap_ptr->msg_code == COAP_MSG_CODE_REQUEST_GET)
    {
        coap_res_ptr = sn_coap_build_response(received_coap_ptr, COAP_MSG_CODE_RESPONSE_CONTENT);

        coap_res_ptr->payload_len = 1;
        coap_res_ptr->payload_ptr = &red_led_state;
        sn_nsdl_send_coap_message(address, coap_res_ptr);
    }
    else if(received_coap_ptr->msg_code == COAP_MSG_CODE_REQUEST_PUT)
    {
        if(received_coap_ptr->payload_len)
        {
            if(*(received_coap_ptr->payload_ptr) == '1')
            {
                RED_ON;
                red_led_state = '1';
                
            }
            else if(*(received_coap_ptr->payload_ptr) == '0')
            {
                RED_OFF;
                red_led_state = '0';
            }
            coap_res_ptr = sn_coap_build_response(received_coap_ptr, COAP_MSG_CODE_RESPONSE_CHANGED);
            sn_nsdl_send_coap_message(address, coap_res_ptr);
        }
    }

    sn_coap_parser_release_allocated_coap_msg_mem(coap_res_ptr);

    return 0;
}


static uint8_t grn_led_resource_cb(sn_coap_hdr_s *received_coap_ptr, sn_nsdl_addr_s *address, sn_proto_info_s * proto)
{
    sn_coap_hdr_s *coap_res_ptr = 0;

    pc.printf("green_led callback\r\n");

    if(received_coap_ptr->msg_code == COAP_MSG_CODE_REQUEST_GET)
    {
        coap_res_ptr = sn_coap_build_response(received_coap_ptr, COAP_MSG_CODE_RESPONSE_CONTENT);

        coap_res_ptr->payload_len = 1;
        coap_res_ptr->payload_ptr = &grn_led_state;
        sn_nsdl_send_coap_message(address, coap_res_ptr);
    }
    else if(received_coap_ptr->msg_code == COAP_MSG_CODE_REQUEST_PUT)
    {
        if(received_coap_ptr->payload_len)
        {
            if(*(received_coap_ptr->payload_ptr) == '1')
            {
                GREEN_ON;
                grn_led_state = '1';
                
            }
            else if(*(received_coap_ptr->payload_ptr) == '0')
            {
                GREEN_OFF;
                grn_led_state = '0';
            }
            coap_res_ptr = sn_coap_build_response(received_coap_ptr, COAP_MSG_CODE_RESPONSE_CHANGED);
            sn_nsdl_send_coap_message(address, coap_res_ptr);
        }
    }

    sn_coap_parser_release_allocated_coap_msg_mem(coap_res_ptr);

    return 0;
}

static uint8_t blu_led_resource_cb(sn_coap_hdr_s *received_coap_ptr, sn_nsdl_addr_s *address, sn_proto_info_s * proto)
{
    sn_coap_hdr_s *coap_res_ptr = 0;

    pc.printf("blue_led callback\r\n");

    if(received_coap_ptr->msg_code == COAP_MSG_CODE_REQUEST_GET)
    {
        coap_res_ptr = sn_coap_build_response(received_coap_ptr, COAP_MSG_CODE_RESPONSE_CONTENT);

        coap_res_ptr->payload_len = 1;
        coap_res_ptr->payload_ptr = &blu_led_state;
        sn_nsdl_send_coap_message(address, coap_res_ptr);
    }
    else if(received_coap_ptr->msg_code == COAP_MSG_CODE_REQUEST_PUT)
    {
        if(received_coap_ptr->payload_len)
        {
            if(*(received_coap_ptr->payload_ptr) == '1')
            {
                BLUE_ON;
                blu_led_state = '1';
                
            }
            else if(*(received_coap_ptr->payload_ptr) == '0')
            {
                BLUE_OFF;
                blu_led_state = '0';
            }
            coap_res_ptr = sn_coap_build_response(received_coap_ptr, COAP_MSG_CODE_RESPONSE_CHANGED);
            sn_nsdl_send_coap_message(address, coap_res_ptr);
        }
    }

    sn_coap_parser_release_allocated_coap_msg_mem(coap_res_ptr);

    return 0;
}

int create_rgbled_resource(sn_nsdl_resource_info_s *resource_ptr)
{
    nsdl_create_dynamic_resource(resource_ptr, sizeof(RED_LED_RES_ID)-1, (uint8_t*)RED_LED_RES_ID, 0, 0, 0, &red_led_resource_cb, (SN_GRS_GET_ALLOWED | SN_GRS_PUT_ALLOWED));
    nsdl_create_dynamic_resource(resource_ptr, sizeof(GRN_LED_RES_ID)-1, (uint8_t*)GRN_LED_RES_ID, 0, 0, 0, &grn_led_resource_cb, (SN_GRS_GET_ALLOWED | SN_GRS_PUT_ALLOWED));
    nsdl_create_dynamic_resource(resource_ptr, sizeof(BLU_LED_RES_ID)-1, (uint8_t*)BLU_LED_RES_ID, 0, 0, 0, &blu_led_resource_cb, (SN_GRS_GET_ALLOWED | SN_GRS_PUT_ALLOWED));
    //initialize state here
    red_led_state = '0';
    grn_led_state = '0';
    blu_led_state = '0';
    RED_OFF;
    GREEN_OFF;
    BLUE_OFF;
    
    return 0;
}