// luminosity resource implementation

#include "mbed.h"
#include "nsdl_support.h"
#include "Wi-Go_eCompass_Lib_V3.h"

#define LIGHT_RES_ID    "3301/0/5700"

extern Serial pc;
extern axis6_t axis6;
char lightPct[5];

/* Only GET method allowed */
static uint8_t light_resource_cb(sn_coap_hdr_s *received_coap_ptr, sn_nsdl_addr_s *address, sn_proto_info_s * proto)
{
    sn_coap_hdr_s *coap_res_ptr = 0;
    sprintf(lightPct,"%d", (axis6.light * 100) / 4096);
    pc.printf("light callback\r\n");
    pc.printf("light level %s\r\n", lightPct);

    if(received_coap_ptr->msg_code == COAP_MSG_CODE_REQUEST_GET)
    {
        coap_res_ptr = sn_coap_build_response(received_coap_ptr, COAP_MSG_CODE_RESPONSE_CONTENT);

        coap_res_ptr->payload_len = strlen(lightPct);
        coap_res_ptr->payload_ptr = (uint8_t*)lightPct;
        sn_nsdl_send_coap_message(address, coap_res_ptr);
    }

    sn_coap_parser_release_allocated_coap_msg_mem(coap_res_ptr);

    return 0;
}

int create_light_resource(sn_nsdl_resource_info_s *resource_ptr)
{
    nsdl_create_dynamic_resource(resource_ptr, sizeof(LIGHT_RES_ID)-1, (uint8_t*)LIGHT_RES_ID, 0, 0, 0, &light_resource_cb, (SN_GRS_GET_ALLOWED));
    return 0;
}