// temperature resource implementation

#include "mbed.h"
#include "nsdl_support.h"
#include "Wi-Go_eCompass_Lib_V3.h"

#define TEMP_RES_ID    "3303/0/5700"

extern Serial pc;
extern axis6_t axis6;
char temp[7];

/* Only GET method allowed */
static uint8_t temp_resource_cb(sn_coap_hdr_s *received_coap_ptr, sn_nsdl_addr_s *address, sn_proto_info_s * proto)
{
    sn_coap_hdr_s *coap_res_ptr = 0;
    sprintf(temp,"%d", axis6.temp);
    pc.printf("temperature callback\r\n");
    pc.printf("temperature %s\r\n", temp);

    if(received_coap_ptr->msg_code == COAP_MSG_CODE_REQUEST_GET)
    {
        coap_res_ptr = sn_coap_build_response(received_coap_ptr, COAP_MSG_CODE_RESPONSE_CONTENT);

        coap_res_ptr->payload_len = strlen(temp);
        coap_res_ptr->payload_ptr = (uint8_t*)temp;
        sn_nsdl_send_coap_message(address, coap_res_ptr);
    }

    sn_coap_parser_release_allocated_coap_msg_mem(coap_res_ptr);
    
    return 0;
}

int create_temp_resource(sn_nsdl_resource_info_s *resource_ptr)
{
    nsdl_create_dynamic_resource(resource_ptr, sizeof(TEMP_RES_ID)-1, (uint8_t*)TEMP_RES_ID, 0, 0, 0, &temp_resource_cb, (SN_GRS_GET_ALLOWED));
    return 0;
}