// accelerometer resource implementation

#include "mbed.h"
#include "nsdl_support.h"
#include "Wi-Go_eCompass_Lib_V3.h"

#define ACCEL_X_RES_ID    "3313/0/0"
#define ACCEL_Y_RES_ID    "3313/0/1"
#define ACCEL_Z_RES_ID    "3313/0/2"

extern Serial pc;
extern axis6_t axis6;
char x[7];
char y[7];
char z[7];

/* Only GET method allowed */

static uint8_t accel_x_resource_cb(sn_coap_hdr_s *received_coap_ptr, sn_nsdl_addr_s *address, sn_proto_info_s * proto)
{
    sn_coap_hdr_s *coap_res_ptr = 0;
    sprintf(x,"%1.2f", axis6.fGax);
    pc.printf("accel x callback\r\n");
    pc.printf("accel x %s\r\n", x);

    if(received_coap_ptr->msg_code == COAP_MSG_CODE_REQUEST_GET)
    {
        coap_res_ptr = sn_coap_build_response(received_coap_ptr, COAP_MSG_CODE_RESPONSE_CONTENT);

        coap_res_ptr->payload_len = strlen(x);
        coap_res_ptr->payload_ptr = (uint8_t*)x;
        sn_nsdl_send_coap_message(address, coap_res_ptr);
    }

    sn_coap_parser_release_allocated_coap_msg_mem(coap_res_ptr);
    
    return 0;
}

static uint8_t accel_y_resource_cb(sn_coap_hdr_s *received_coap_ptr, sn_nsdl_addr_s *address, sn_proto_info_s * proto)
{
    sn_coap_hdr_s *coap_res_ptr = 0;
    sprintf(y,"%1.2f", axis6.fGay);
    pc.printf("accel y callback\r\n");
    pc.printf("accel y %s\r\n", y);

    if(received_coap_ptr->msg_code == COAP_MSG_CODE_REQUEST_GET)
    {
        coap_res_ptr = sn_coap_build_response(received_coap_ptr, COAP_MSG_CODE_RESPONSE_CONTENT);

        coap_res_ptr->payload_len = strlen(y);
        coap_res_ptr->payload_ptr = (uint8_t*)y;
        sn_nsdl_send_coap_message(address, coap_res_ptr);
    }

    sn_coap_parser_release_allocated_coap_msg_mem(coap_res_ptr);
    
    return 0;
}

static uint8_t accel_z_resource_cb(sn_coap_hdr_s *received_coap_ptr, sn_nsdl_addr_s *address, sn_proto_info_s * proto)
{
    sn_coap_hdr_s *coap_res_ptr = 0;
    sprintf(z,"%1.2f", axis6.fGaz);
    pc.printf("accel z callback\r\n");
    pc.printf("accel z %s\r\n", z);

    if(received_coap_ptr->msg_code == COAP_MSG_CODE_REQUEST_GET)
    {
        coap_res_ptr = sn_coap_build_response(received_coap_ptr, COAP_MSG_CODE_RESPONSE_CONTENT);

        coap_res_ptr->payload_len = strlen(z);
        coap_res_ptr->payload_ptr = (uint8_t*)z;
        sn_nsdl_send_coap_message(address, coap_res_ptr);
    }

    sn_coap_parser_release_allocated_coap_msg_mem(coap_res_ptr);
    
    return 0;
}

int create_accel_resource(sn_nsdl_resource_info_s *resource_ptr)
{
    nsdl_create_dynamic_resource(resource_ptr, sizeof(ACCEL_X_RES_ID)-1, (uint8_t*)ACCEL_X_RES_ID, 0, 0, 0, &accel_x_resource_cb, (SN_GRS_GET_ALLOWED));
    nsdl_create_dynamic_resource(resource_ptr, sizeof(ACCEL_Y_RES_ID)-1, (uint8_t*)ACCEL_Y_RES_ID, 0, 0, 0, &accel_y_resource_cb, (SN_GRS_GET_ALLOWED));
    nsdl_create_dynamic_resource(resource_ptr, sizeof(ACCEL_Z_RES_ID)-1, (uint8_t*)ACCEL_Z_RES_ID, 0, 0, 0, &accel_z_resource_cb, (SN_GRS_GET_ALLOWED));
    return 0;
}