#include "mbed.h"
#include "cc3000.h"
#include "nsdl_support.h"
#include "dbg.h"
#include "UDPSocket.h"
#include "Endpoint.h"
#include "battery.h"
#include "light.h"
#include "temperature.h"
#include "altitude.h"
#include "slider.h"
#include "accelerometer.h"
#include "magnetometer.h"
#include "rgbled.h"

extern Serial pc;

// ****************************************************************************
// Configuration section

// default timeout values for DHCP, ARP, keepalive, disable socket timeout
uint32_t dhcp = 14400;
uint32_t arp = 3600;
uint32_t keep_alive = 10;
uint32_t inactivity = 0;
int32_t to_rtn;

// NSP configuration
/* Change this IP address to that of your NanoService Platform installation */
static const char* NSP_ADDRESS = "192.168.1.220"; /* Arndale board running NSP on local network for Hackathon */ 
//static const char* NSP_ADDRESS = "198.41.30.241"; /* Eclipse LWM2M sandbox */ 
//static const char* NSP_ADDRESS = "217.140.101.20"; /* public mbed demo server */ 
static const int NSP_PORT = 5683;
//static const int NSP_PORT = 5684; /* lwm2m sandbox port */
char endpoint_name[24] = "mbed-";
//char endpoint_name[24] = "urn:mac:";
uint8_t ep_type[] = {"mbed_device"};
uint8_t lifetime_ptr[] = {"120000"}; //30+ hours 

uint8_t myMAC[8];
char MAC[20];

// ****************************************************************************
// Ethernet initialization

// EthernetInterface eth;
extern cc3000 wifi;

static void ethernet_init()
{

// set timeout values to disable socket timeout  
    to_rtn = wifi._netapp.timeout_values(&dhcp, &arp, &keep_alive, &inactivity);
    pc.printf("timeout set: %d\r\n", to_rtn);

//    make a unique name from the MAC address
      wifi.get_mac_address(myMAC);
      printf("MAC address %02x:%02x:%02x:%02x:%02x:%02x \r\n", myMAC[0], myMAC[1], myMAC[2], myMAC[3], myMAC[4], myMAC[5]);
      sprintf(MAC, "%02X%02X%02X%02X%02X%02X", myMAC[0], myMAC[1], myMAC[2], myMAC[3], myMAC[4], myMAC[5]);
      pc.printf("MAC: %s", MAC);
    
//    mbed_uid[32] = '\0';
//    strncat(endpoint_name, mbed_uid + 27, 15 - len(endpoint_name));
      strncat(endpoint_name, MAC, 12);
      pc.printf("EP NAME: %s\r\n",endpoint_name);

    NSDL_DEBUG("IP Address:%s ", wifi.getIPAddress());
}

// ****************************************************************************
// NSP initialization

extern UDPSocket server;
extern Endpoint nsp;

static void nsp_init()
{
    server.init();
    server.bind(NSP_PORT);

    nsp.set_address(NSP_ADDRESS, NSP_PORT);
    
    NSDL_DEBUG("name: %s", endpoint_name);
    NSDL_DEBUG("NSP=%s - port %d\n", NSP_ADDRESS, NSP_PORT);
}

// ****************************************************************************
// Resource creation

static int create_resources()
{
    sn_nsdl_resource_info_s *resource_ptr = NULL;
    sn_nsdl_ep_parameters_s *endpoint_ptr = NULL;
    
    NSDL_DEBUG("Creating resources");

    /* Create resources */
    resource_ptr = (sn_nsdl_resource_info_s*)nsdl_alloc(sizeof(sn_nsdl_resource_info_s));
    if(!resource_ptr)
        return 0;
    memset(resource_ptr, 0, sizeof(sn_nsdl_resource_info_s));

    resource_ptr->resource_parameters_ptr = (sn_nsdl_resource_parameters_s*)nsdl_alloc(sizeof(sn_nsdl_resource_parameters_s));
    if(!resource_ptr->resource_parameters_ptr)
    {
        nsdl_free(resource_ptr);
        return 0;
    }
    memset(resource_ptr->resource_parameters_ptr, 0, sizeof(sn_nsdl_resource_parameters_s));

    // Static resources
    nsdl_create_static_resource(resource_ptr, sizeof("dev/mfg")-1, (uint8_t*) "dev/mfg", 0, 0,  (uint8_t*) "AvnetFreescale", sizeof("AvnetFreescale")-1);
    nsdl_create_static_resource(resource_ptr, sizeof("dev/mdl")-1, (uint8_t*) "dev/mdl", 0, 0,  (uint8_t*) "WiGoSystem", sizeof("WiGiSystem")-1);

    // Dynamic resources
    create_battery_resource(resource_ptr); 
    create_light_resource(resource_ptr); 
    create_temp_resource(resource_ptr); 
    create_alt_resource(resource_ptr); 
    create_slider_resource(resource_ptr); 
    create_accel_resource(resource_ptr); 
    create_magnet_resource(resource_ptr); 
    create_rgbled_resource(resource_ptr); 

        /* Register with NSP */
    endpoint_ptr = nsdl_init_register_endpoint(endpoint_ptr, (uint8_t*)endpoint_name, ep_type, lifetime_ptr);
    if(sn_nsdl_register_endpoint(endpoint_ptr) != 0)
        pc.printf("NSP registering failed\r\n");
    else
        pc.printf("NSP registering OK\r\n");
    nsdl_clean_register_endpoint(&endpoint_ptr);

    nsdl_free(resource_ptr->resource_parameters_ptr);
    nsdl_free(resource_ptr);
    return 1;
}

// ****************************************************************************
// Program entry point
// this modified to startup as an option in the Wi-Go demo

void nsdl_run()
{
//    lcd.cls();
//    lcd.locate(0,0);
//    lcd.printf("mbed NanoService demo");
    NSDL_DEBUG("ARM mbed NanoService Demo on Wi-Go for IoT World Hackathon\n");
    
    // Initialize Ethernet interface first
    ethernet_init();
    
    // Initialize NSP node
    nsp_init();
    
    // Initialize NSDL stack
    nsdl_init();
    
    // Create NSDL resources
    create_resources();
    
    // Run the NSDL event loop (never returns)
    nsdl_event_loop();
}

