#include "mbed.h"
#include "C027.h"
#include "C12832_lcd.h"
#include "LM75B.h"
#include "MMA7660.h"

//#define MBED_APPS_SHIELD
#define MBED_APPS_BOARD

#if defined(MBED_APPS_SHIELD)
  C12832_LCD lcd(D11, D13, D12, D7, D10);
  DigitalOut myled(P3_25);
  LM75B temperature_sensor(SDA, SCL);
  MMA7660 mma(SDA, SCL);
#elif defined(MBED_APPS_BOARD)
  C12832_LCD lcd(p5, p7, p6, p8, p11);
  DigitalOut myled(LED1);
  LM75B temperature_sensor(p28, p27);
  MMA7660 mma(p28, p27);
#else
#error application board not defined
#endif

int main() {
    lcd.cls();
    lcd.locate(0,3);
    lcd.printf("Sensor Lab\n");
    while(1) {
        myled = 1;
        wait(0.2);
        myled = 0;
        wait(0.2);
        float temperature = temperature_sensor;
        float x = mma.x();
        float y = mma.y();
        float z = mma.z();
    }
}
