#include "mbed.h"
#include "C027.h"
#include "C12832_lcd.h"

#define MBED_APPS_SHIELD
//#define MBED_APPS_BOARD

#if defined(MBED_APPS_SHIELD)
  PwmOut spkr(D6);
  DigitalOut myled(P3_25);
  C12832_LCD lcd(D11, D13, D12, D7, D10);
#elif defined(MBED_APPS_BOARD)
  PwmOut spkr(p26);
  C12832_LCD lcd(p5, p7, p6, p8, p11);
  DigitalOut myled(LED1);
#else
#error application board not defined
#endif

int main()
{
    lcd.cls();
    lcd.locate(0.,3);
    lcd.printf("Buzzer test!\n");
    while(1) {
        for(int j=0; j<3; j++) {
            for (float i=2000.0; i<4000.0; i+=100) {
                spkr.period(1.0/i);
                spkr=0.5;
                wait(0.1);
                myled = !myled;
            }
            spkr=0.0;
            wait(2.0f);
        }
    }
}
