#include "mbed.h"
#include "cc3000.h"
#include "nsdl_support.h"
#include "dbg.h"
#include "UDPSocket.h"
#include "Endpoint.h"

// Include resources
#include "light.h"

using namespace mbed_cc3000;

Serial pc(USBTX, USBRX); // tx, rx

// ****************************************************************************
// Configuration section


// Ethernet configuration
/* Define this to enable DHCP, otherwise manual address configuration is used */
#define DHCP

// default timeout values for DHCP, ARP, keepalive, disable socket timeout
uint32_t dhcp = 14400;
uint32_t arp = 3600;
uint32_t keep_alive = 10;
uint32_t inactivity = 0;
int32_t to_rtn;

  
/* Manual IP configurations, if DHCP not defined */
#define IP      "10.0.0.199"
#define MASK    "255.255.255.0"
#define GW      "10.0.0.1"


// NSP configuration
/* Change this IP address to that of your NanoService Platform installation */
static const char* NSP_ADDRESS = "23.102.162.118"; // coen296.cloudapp.net
//static const char* NSP_ADDRESS = "192.168.1.200"; // local mDS server
static const int NSP_PORT = 5683;
char endpoint_name[24] = "mbedDEMO-";
uint8_t ep_type[] = {"DEMO"};
uint8_t lifetime_ptr[] = {"60"};

// ****************************************************************************
// Ethernet initialization

//EthernetInterface eth;
//cc3000 eth(D2, D7, D10, SPI(D11, D12, D13), "SCUGuest", "", NONE, false);//Sparkfun
//cc3000 eth(D2, D7, D10, SPI(D11, D12, D13), "demo", "ARMDEMO1", WPA2, false);//Sparkfun
cc3000 eth(D3, D5, D10, SPI(D11, D12, D13), "SCUGuest", "", NONE, false);//Adafruit

static void ethernet_init()
{
    
// set timeout values to disable socket timeout  
/*    pc.printf("Setting timeout values\r\n");
    to_rtn = eth._netapp.timeout_values(&dhcp, &arp, &keep_alive, &inactivity);
    pc.printf("timeout set: %d\r\n", to_rtn);
*/
    /* Initialize network */
#ifdef DHCP
    NSDL_DEBUG("DHCP in use\r\n");
    eth.init();
    NSDL_DEBUG("eth.init\r\n");
#else
    eth.init(IP, MASK, GW);
    NSDL_DEBUG("eth.init\r\n");
#endif
    if(eth.connect(30000) == 0)
        pc.printf("Connect OK\n\r");

    NSDL_DEBUG("IP Address:%s ", eth.getIPAddress());
}

// ****************************************************************************
// NSP initialization

UDPSocket server;
Endpoint nsp;
bool UDP_blocking = false;
unsigned int UDP_timeout = 1000;

uint8_t macbytes[6] = {0};
char MAC[20];

static void nsp_init()
{
    server.init();
    //pc.printf("socket init\r\n");
    server.bind(NSP_PORT);
    //pc.printf("socket bind\r\n");
    server.set_blocking(UDP_blocking, UDP_timeout);

    nsp.set_address(NSP_ADDRESS, NSP_PORT);

    eth.get_mac_address(macbytes);
    
    sprintf(MAC, "%02X%02X%02X%02X%02X%02X", macbytes[0], macbytes[1], macbytes[2], macbytes[3], macbytes[4], macbytes[5]);
    pc.printf("MAC: %s\r\n", MAC);
    
    strncat(endpoint_name, MAC, 12);
    
    NSDL_DEBUG("name: %s", endpoint_name);
    NSDL_DEBUG("NSP=%s - port %d\n", NSP_ADDRESS, NSP_PORT);

}

// ****************************************************************************
// Resource creation

static int create_resources()
{
    sn_nsdl_resource_info_s *resource_ptr = NULL;
    sn_nsdl_ep_parameters_s *endpoint_ptr = NULL;
    
    NSDL_DEBUG("Creating resources");

    /* Create resources */
    resource_ptr = (sn_nsdl_resource_info_s*)nsdl_alloc(sizeof(sn_nsdl_resource_info_s));
    if(!resource_ptr)
        return 0;
    memset(resource_ptr, 0, sizeof(sn_nsdl_resource_info_s));

    resource_ptr->resource_parameters_ptr = (sn_nsdl_resource_parameters_s*)nsdl_alloc(sizeof(sn_nsdl_resource_parameters_s));
    if(!resource_ptr->resource_parameters_ptr)
    {
        nsdl_free(resource_ptr);
        return 0;
    }
    memset(resource_ptr->resource_parameters_ptr, 0, sizeof(sn_nsdl_resource_parameters_s));

    // Static resources
    nsdl_create_static_resource(resource_ptr, sizeof("3/0/0")-1, (uint8_t*) "3/0/0", 0, 0,  (uint8_t*) "mbedDEMO", sizeof("mbedDEMO")-1);
    nsdl_create_static_resource(resource_ptr, sizeof("3/0/1")-1, (uint8_t*) "3/0/1", 0, 0,  (uint8_t*) "DEMO", sizeof("DEMO")-1);

    // Dynamic resources
    create_light_resource(resource_ptr);

        /* Register with NSP */
    endpoint_ptr = nsdl_init_register_endpoint(endpoint_ptr, (uint8_t*)endpoint_name, ep_type, lifetime_ptr);
    if(sn_nsdl_register_endpoint(endpoint_ptr) != 0)
        pc.printf("NSP registering failed\r\n");
    else
        pc.printf("NSP registering OK\r\n");
    nsdl_clean_register_endpoint(&endpoint_ptr);

    nsdl_free(resource_ptr->resource_parameters_ptr);
    nsdl_free(resource_ptr);
    return 1;
}

// ****************************************************************************
// Program entry point

int main()
{

    NSDL_DEBUG("Hello mDS Demo Endpoint Application\n");
    
    // Initialize Ethernet interface first
    ethernet_init();
    
    // Initialize NSP node
    nsp_init();
    
    // Initialize NSDL stack
    nsdl_init();
    
    // Create NSDL resources
    create_resources();
    
    // Run the NSDL event loop (never returns)
    nsdl_event_loop();
}
