#include "mbed.h"
#include "EthernetInterface.h"
#include "nsdl_support.h"
#include "dbg.h"
// Include resources
#include "light.h"
#include "IAP.h"
#include "PololuLedStrip.h"
PololuLedStrip ledStrip(P0_4);
//#define LED_COUNT 60
#define LED_COUNT 120
rgb_color colors[LED_COUNT];

Serial pc(USBTX, USBRX); // tx, rx

// ****************************************************************************
// Configuration section

// Ethernet configuration
/* Define this to enable DHCP, otherwise manual address configuration is used */
#define DHCP

/* Manual IP configurations, if DHCP not defined */
#define IP      "10.0.0.199"
#define MASK    "255.255.255.0"
#define GW      "10.0.0.1"

extern "C" void mbed_mac_address(char *mac)
{
    static char buf[64] = {0};
    IAP iap;
    int32_t *block = iap.read_serial();
    uint32_t serial_number[5] = {0};
    
    memset(buf, 0, sizeof(buf));
    serial_number[0] = *(block);
    serial_number[1] = *(block+1);
    // we only want bottom 16 bits of word1 (MAC bits 32-47)
    // and bit 9 forced to 1, bit 8 forced to 0
    // Locally administered MAC, reduced conflicts
    // http://en.wikipedia.org/wiki/MAC_address
    //serial_number[0] |= 0x00000200;
    //serial_number[0] &= 0x0000FEFF;
    memcpy(mac, (uint8_t*) &serial_number[0], 6);
    mac[0] |= 0x02;
    mac[0] &= 0xFE;
    mac[5] |= 0x02;
    mac[5] &= 0xFE;
     
    // snprintf(buf, 16, "%4X%08X", serial_number[0], serial_number[1]);
}  

 
// NSP configuration
/* Change this IP address to that of your NanoService Platform installation */
//static const char* NSP_ADDRESS = "54.228.25.31/"; /* Leshan Sandbox */ 
static const char* NSP_ADDRESS = "192.168.1.200"; 
static const int NSP_PORT = 5683;
char endpoint_name[24] = "LED-booth-";
uint8_t ep_type[] = {"LED-STRIP"};
uint8_t lifetime_ptr[] = {"60"};

// ****************************************************************************
// Ethernet initialization

EthernetInterface eth;
static void ethernet_init()
{
    /* Initialize network */
#ifdef DHCP
    NSDL_DEBUG("DHCP in use\r\n");
    eth.init();
    NSDL_DEBUG("eth.init\r\n");
#else
    eth.init(IP, MASK, GW);
    NSDL_DEBUG("eth.init\r\n");
#endif
    if(eth.connect(30000) == 0)
        pc.printf("Connect OK\n\r");

    NSDL_DEBUG("IP Address:%s ", eth.getIPAddress());
}

// ****************************************************************************
// NSP initialization

UDPSocket server;
Endpoint nsp;

char * ipstring;
char * uid;

static void nsp_init()
{
    server.init();
    server.bind(NSP_PORT);

    nsp.set_address(NSP_ADDRESS, NSP_PORT);
    
    ipstring = eth.getIPAddress();
    uid = ipstring;
    
    while(*ipstring)
    {
        if(*ipstring =='.')
            *ipstring='-';
        ipstring++;

    }
    strncat( endpoint_name, uid, strlen(uid) );
    pc.printf("\r\nep name: %s\r\n", endpoint_name);

    NSDL_DEBUG("name: %s", endpoint_name);
    NSDL_DEBUG("NSP=%s - port %d\n", NSP_ADDRESS, NSP_PORT);

}

// ****************************************************************************
// Resource creation

static int create_resources()
{
    sn_nsdl_resource_info_s *resource_ptr = NULL;
    sn_nsdl_ep_parameters_s *endpoint_ptr = NULL;
    
    NSDL_DEBUG("Creating resources");

    /* Create resources */
    resource_ptr = (sn_nsdl_resource_info_s*)nsdl_alloc(sizeof(sn_nsdl_resource_info_s));
    if(!resource_ptr)
        return 0;
    memset(resource_ptr, 0, sizeof(sn_nsdl_resource_info_s));

    resource_ptr->resource_parameters_ptr = (sn_nsdl_resource_parameters_s*)nsdl_alloc(sizeof(sn_nsdl_resource_parameters_s));
    if(!resource_ptr->resource_parameters_ptr)
    {
        nsdl_free(resource_ptr);
        return 0;
    }
    memset(resource_ptr->resource_parameters_ptr, 0, sizeof(sn_nsdl_resource_parameters_s));

    // Static resources
    nsdl_create_static_resource(resource_ptr, sizeof("3/0/0")-1, (uint8_t*) "3/0/0", 0, 0,  (uint8_t*) "ARMDEMO", sizeof("ARMDEMO")-1);
    nsdl_create_static_resource(resource_ptr, sizeof("3/0/1")-1, (uint8_t*) "3/0/1", 0, 0,  (uint8_t*) "LED-STRIP", sizeof("LED-STRIP")-1);

    // Dynamic resources
    create_light_resource(resource_ptr);

        /* Register with NSP */
    endpoint_ptr = nsdl_init_register_endpoint(endpoint_ptr, (uint8_t*)endpoint_name, ep_type, lifetime_ptr);
    if(sn_nsdl_register_endpoint(endpoint_ptr) != 0)
        pc.printf("NSP registering failed\r\n");
    else
        pc.printf("NSP registering OK\r\n");
    nsdl_clean_register_endpoint(&endpoint_ptr);

    nsdl_free(resource_ptr->resource_parameters_ptr);
    nsdl_free(resource_ptr);
    return 1;
}

void set_led_color(char *color_string)
{
static uint8_t red, green, blue, index ;
int color_int ;

    sscanf(color_string, "%X", &color_int);
    
    index = color_int & 255;
    blue = color_int >> 8 & 255;
    green = color_int >> 16 & 255;
    red = color_int >> 24 & 255;
        
    if(index > 0 and index <= LED_COUNT)
    {
        colors[index-1] = (rgb_color) {red,green,blue} ;
        ledStrip.write(colors, LED_COUNT);
    }
    else if(index == 0)
    {
        for(int i = 0; i < LED_COUNT; i++)
        {
            colors[i] = (rgb_color) {red,green,blue} ;
            ledStrip.write(colors, LED_COUNT);
            wait_ms(10);
        }
    }    
}


// ****************************************************************************
// Program entry point

int main()
{
    char foo[6] = {0};
    
    mbed_mac_address(foo);
    
    pc.printf("mac:\r\n");
    for (int i = 0; i < 6; i++) {
      pc.printf("%x, ", foo[i]);    
    }

    NSDL_DEBUG("mbed NanoService Example App 0.1\n");
    
    // Initialize Ethernet interface first
    ethernet_init();
    
    // Initialize NSP node
    nsp_init();
    
    // Initialize NSDL stack
    nsdl_init();
    
    // Create NSDL resources
    create_resources();
    
    // Run the NSDL event loop (never returns)
    nsdl_event_loop();
}
