/*******************************************************************************
 * Copyright (C) 2017 Maxim Integrated Products, Inc., All Rights Reserved.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a
 * copy of this software and associated documentation files (the "Software"),
 * to deal in the Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, sublicense,
 * and/or sell copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included
 * in all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
 * OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
 * IN NO EVENT SHALL MAXIM INTEGRATED BE LIABLE FOR ANY CLAIM, DAMAGES
 * OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE,
 * ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR
 * OTHER DEALINGS IN THE SOFTWARE.
 *
 * Except as contained in this notice, the name of Maxim Integrated
 * Products, Inc. shall not be used except as stated in the Maxim Integrated
 * Products, Inc. Branding Policy.
 *
 * The mere transfer of this software does not imply any licenses
 * of trade secrets, proprietary technology, copyrights, patents,
 * trademarks, maskwork rights, or any other form of intellectual
 * property whatsoever. Maxim Integrated Products, Inc. retains all
 * ownership rights.
 *******************************************************************************
 */
 
 
#include "MAX2871.h"
#include <math.h>
#include <stdio.h>
 
//****************************************************************************
MAX2871::MAX2871(SPI &spiBus, PinName le):
m_spiBus(spiBus), m_le(le, 1)
{
    f_reference = 50.0;
    
    reg0.all = 0x007d0000;
    reg1.all = 0x2000fff9;
    reg2.all = 0x00004042;
    reg3.all = 0x0000000b;
    reg4.all = 0x6180b23c;
    reg5.all = 0x00400005;
    reg6.all = 0x00000000;
    update();
}

//****************************************************************************
MAX2871::~MAX2871()
{
    //empty block
}

//****************************************************************************    
void MAX2871::writeRegister(const uint32_t data)
{
    m_le = 0;
    m_spiBus.write((0xFF000000 & data) >> 24);
    m_spiBus.write((0x00FF0000 & data) >> 16);
    m_spiBus.write((0x0000FF00 & data) >> 8);
    m_spiBus.write( 0x000000FF & data);
    m_le = 1;
}

//****************************************************************************    
void MAX2871::readRegister6()
{
    uint32_t raw, reg6read;
    
    reg5.bits.mux = 1;
    reg2.bits.mux = 0x4;
    writeRegister(reg5.all);
    writeRegister(reg2.all);
    
    writeRegister(0x00000006);
    
    m_spiBus.format(8,1);
    
    raw = m_spiBus.write(0x00);
    reg6read = (reg6read & 0x01FFFFF) + (raw << 25);
    raw = m_spiBus.write(0x00);
    reg6read = (reg6read & 0xFE01FFFF) + (raw << 17); 
    raw = m_spiBus.write(0x00);
    reg6read = (reg6read & 0xFFFE01FF) + (raw << 9);
    raw = m_spiBus.write(0x00);
    reg6read = (reg6read & 0xFFFFFE01) + (raw << 1);
    raw = m_spiBus.write(0x00);
    reg6read = (reg6read & 0xFFFFFFFE) + (raw >> 7);
    reg6.all = reg6read;
    
    m_spiBus.format(8,0);
}

//****************************************************************************    
void MAX2871::update()
{
    writeRegister(reg5.all);
    writeRegister(reg4.all);
    writeRegister(reg3.all);
    writeRegister(reg2.all);
    writeRegister(reg1.all);
    writeRegister(reg0.all);
}

//****************************************************************************    
void MAX2871::frequency(const float freq)
{
    uint32_t n,frac,m = 0;
    float pll_coefficient;
    
    float f_pfd = f_reference*(1+reg2.bits.dbr)/(reg2.bits.r*(1+reg2.bits.rdiv2));
    
    reg4.bits.diva = 0;
    while(freq*powf(2,reg4.bits.diva) < 3000.0)
    {
        reg4.bits.diva = reg4.bits.diva + 1;
    }
    pll_coefficient = freq*powf(2,reg4.bits.diva)/f_pfd;
    
    n = floor(pll_coefficient);
    pll_coefficient = pll_coefficient - n;
    
    m = 4000;
    frac = floor(m*pll_coefficient);
    
    reg0.bits.frac = frac;
    reg0.bits.n = n;
    reg1.bits.m = m;
    update();
}
