#include "mbed.h"
#include "max32630fthr.h"
#include "MAX113XX_Pixi.h"
#include "MAX11301Hex.h"

MAX32630FTHR pegasus(MAX32630FTHR::VIO_3V3);

int main()
{
    Serial pc(USBTX, USBRX);            // Use USB debug probe for serial link
    pc.baud(115200);                    // Baud rate = 115200
    
    I2C i2cBus(I2C1_SDA, I2C1_SCL);     // I2C bus, P3_4 = SDA, P3_5 = SCL

    MAX113XX_I2C * pixi;
    pixi = new MAX113XX_I2C(i2cBus, MAX113XX_I2C::MAX11301, 0x38, P5_5);
        
    pixi->dacWrite(MAX113XX_Pixi::PORT0, 0x000);    // Pixi PORT0 is -5V
    pixi->dacWrite(MAX113XX_Pixi::PORT1, 0xFFF);    // Pixi PORT1 is +5V
    
    uint16_t adcData, idx;
    float adcVoltage;
    while(1) {
        
        pixi->singleEndedADCRead(MAX113XX_Pixi::PORT9, adcData);    // Read value from PORT9
        adcVoltage = -5 + 2.442e-3  * adcData;                      // Convert ADC val to a voltage
        pc.printf("ADC Read is : %i,\tVoltage is %1.3f V \r\n", adcData, adcVoltage);
        wait(0.05);   
    }
}

